/*
 * Create readahead thrashing.
 *
 * Very simplistic: just read from a number of files in sequence.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <getopt.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include <assert.h>

char *ourname;
char *read_buffer;
int read_size = 4096;
int do_read;

struct readfile {
	char *filename;
	int fd;
} *readfiles;
int nr_readfiles;

ssize_t pread(int fd, void *buf, size_t count, off_t offset);

void usage(void)
{
	fprintf(stderr,
		"Usage: %s [-b N] filename ...\n",
			ourname);
	fprintf(stderr, "         -b N : read chunk size (bytes)\n");
	exit(1);
}

void __doit_read(struct readfile *rf)
{
	if (read(rf->fd, read_buffer, read_size) != read_size) {
		close(rf->fd);
		rf->fd = 0;
	}
}

static void doit_read(void)
{
	int i;
	int did_stuff;

	do {
		did_stuff = 0;
		for (i = 0; i < nr_readfiles; i++) {
			if (readfiles[i].fd) {
				__doit_read(readfiles + i);
				did_stuff = 1;
			}
		}
	} while (did_stuff);
}

int main(int argc, char *argv[])
{
	int c;
	int i;

	ourname = argv[0];
	while ((c = getopt(argc, argv, "b:h:")) != -1) {
		switch (c) {
		case 'b':
			read_size = strtol(optarg, NULL, 10);
			break;
		default:
			usage();
		}
	}

	if (optind == argc)
		usage();

	read_buffer = malloc(read_size);
	if (!read_buffer) {
		fprintf(stderr, "enomem\n");
		exit(1);
	}

	nr_readfiles = argc - optind;
	readfiles = malloc(nr_readfiles * sizeof(*readfiles));
	assert(readfiles);

	for (i = 0; i < nr_readfiles; i++) {
		readfiles[i].filename = argv[optind + i];
		readfiles[i].fd = open(readfiles[i].filename, O_RDONLY);
		if (readfiles[i].fd < 0) {
			fprintf(stderr, "%s: failed to open %s: %s\n",
				ourname,
				readfiles[i].filename,
				strerror(errno));
			exit(1);
		}
	}

	doit_read();
	exit(0);
}
