#include <linux/types.h>
#include <linux/unistd.h>
#include <stdio.h>
#include <errno.h>

#ifndef __NR_statfs64
#define __NR_statfs64 269
#endif

typedef __kernel_fsid_t	fsid_t;

struct statfs {
	__u32 f_type;
	__u32 f_bsize;
	__u32 f_blocks;
	__u32 f_bfree;
	__u32 f_bavail;
	__u32 f_files;
	__u32 f_ffree;
	__kernel_fsid_t f_fsid;
	__u32 f_namelen;
	__u32 f_frsize;
	__u32 f_spare[5];
};

struct statfs64 {
	__u32 f_type;
	__u32 f_bsize;
	__u64 f_blocks;
	__u64 f_bfree;
	__u64 f_bavail;
	__u64 f_files;
	__u64 f_ffree;
	__kernel_fsid_t f_fsid;
	__u32 f_namelen;
	__u32 f_frsize;
	__u32 f_spare[5];
};


_syscall3(long, statfs64, const char *, path, size_t, sz, struct statfs64 *, buf);

int main(int ac, char **av)
{
	while (*++av) {
		struct statfs64 x;
		if (statfs64(*av, sizeof x, &x) != 0)
			perror(*av);
		else {
			printf("%s: type %lx, blksize %lu, blocks %llu, free %llu\n"
			       "files %llu, ffree %llu,"
			       "fsid %08x%08x, namelen %lu, frsize %lu\n",
			       *av,
			       (unsigned long)x.f_type,
			       (unsigned long)x.f_bsize,
			       x.f_blocks,
			       x.f_bavail,
			       x.f_files,
			       x.f_ffree,
			       x.f_fsid.__val[0],
			       x.f_fsid.__val[1],
			       (unsigned long)x.f_namelen,
			       (unsigned long)x.f_frsize);
		}
	}
	return 0;
}

