#!/bin/sh
#
# Test the e2fsck character-special orphan inode recovery thing
#

usage()
{
	echo "Usage: fsck-recovery-bug.sh /dev/hdXX /mnt/mntpoint"
	exit 1
}

if [ $# != 2 ]
then
	usage
fi

DEVICE=$1
MOUNTPOINT=$2
ZERO=$MOUNTPOINT/zero

# Mount the fs, timebombed for 3 seconds
umount $DEVICE
mount $DEVICE $MOUNTPOINT -o ro-after=300

# Put a /dev/zero on target device
rm -f $ZERO
mknod $ZERO c 1 5

echo "here's the inode:"
ls -li $ZERO

echo "Here's the inode info"
echo "stat zero" | debugfs $DEVICE

# Open it
( sleep 1000 & ) < $ZERO

# Remove it
rm $ZERO

# Force a commit
sync

echo Wait for fs to go read-only
sleep 5
echo OK
killall sleep

umount $DEVICE
# e2fsck -fy $DEVICE
