#!/bin/sh
#
# testing/recovery-data-test.sh
#
# This script tests data integrity after recovery.  Uses a hacked-up
# dbench which writes known data.
#
# 1 : Mount the ext3 FS, set to go readonly after period_of_time
# 2 : Run test_script
# 3 : Wait for the filesystem to go readonly
# 5 : Kill the test_script
# 6 : umount the target fs
# 8 : Mount the target fs			(run in-kernel recovery)
# 9: Run check-hacked-dbench-file		(should exit 0: clean)
# 10 : unmount the target fs
# 11: Modify period_of_time
# 12: Repeat ad-nauseum
#
# Usage:
#	recovery-test.sh /dev/hda1 /mnt/mount-point test-script [min_jiffies max_jiffies]
#
# This one, you must run as root
#

. functions

usage()
{
	echo "Usage: recovery-data-test.sh /dev/hda1 /mnt/mount-point test_script"
	exit 1
}

MIN_JIFFIES=1000
MAX_JIFFIES=10000

if [ $# == 5 ]
then
	MIN_JIFFIES=$4
	MAX_JIFFIES=$5
elif [ $# != 3 ]
then
	usage
fi

DEVICE=$1
MOUNT_POINT=$2
TEST_SCRIPT=$3
PERIOD_OF_TIME=$MIN_JIFFIES

umount $DEVICE

while true
do
	mount_fs
	remove_dbench_files
	unmount_fs
	mount_fs -o ro-after=$PERIOD_OF_TIME,data=ordered	# Mount, timebombed
	run_test_script				# Run the test script
	wait_for_readonly			# Wait until immutable
	kill_test_script			# Kill the test scripts
	unmount_fs				# Unmount it
#	run_e2fsck -f -d -v
	mount_fs				# Run recovery
	run_chdf				# Check sanity
	unmount_fs
	run_e2fsck -fn
	modify_period_of_time			# Next readonly delay
done
