
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>
#include <sched.h>
#include <signal.h>
#include <sys/mman.h>
#include <sys/uio.h>
#include <setjmp.h>

#include "fadvise.h"

int fd;
char *map;
char stack[64*1024];
char writebuf0[4096];
char writebuf1[4096];
int exitted;

void do_exit(int code)
{
	exitted = 1;
	fprintf(stderr, "do_exit(%d)\n", code);
	exit(code);
}

int unmapper(void *p)
{
	while (!exitted) {
		if (madvise(map, 8192, MADV_DONTNEED) < 0) {
			perror("madvise");
			do_exit(1);
		}
		if (__posix_fadvise64(fd, 0, 8192, POSIX_FADV_DONTNEED) < 0) {
			perror("fadvise");
			do_exit(1);
		}
	}
	return 0;
}

int main(int argc, char *argv[])
{
	struct iovec iov[2];

	fd = open("foo", O_CREAT|O_RDWR|O_TRUNC|O_SYNC, 0666);
	if (fd < 0) {
		perror("open");
		do_exit(1);
	}
	if (write(fd, writebuf0, sizeof(writebuf0)) != sizeof(writebuf0)) {
		perror("write");
		do_exit(1);
	}
	if (write(fd, writebuf1, sizeof(writebuf1)) != sizeof(writebuf1)) {
		perror("write");
		do_exit(1);
	}
	map = mmap(0, 8192, PROT_READ|PROT_WRITE, MAP_SHARED, fd, 0);
	if (map == MAP_FAILED) {
		perror("mmap");
		do_exit(1);
	}
	if (clone(unmapper, stack+sizeof(stack),
			CLONE_FILES|CLONE_FS|CLONE_VM, NULL) < 0) {
		perror("clone");
		do_exit(1);
	}

	/*
	 * The first segment will cause us to write to the first page from
	 * within the second page.  The second segment will cause us to write
	 * into the first page from within the first page.  But the kernel only
	 * faults in the page at the zeroeth iovec segment.   So it'll take a
	 * pagefault against the current-locked page, which is not uptodate.
	 */
	iov[0].iov_base = map + 4096;
	iov[0].iov_len = 1;
	iov[1].iov_base = map + 0;
	iov[1].iov_len = 1;
	while (!exitted) {
		if (lseek(fd, 0, SEEK_SET) != 0) {
			perror("lseek");
			do_exit(1);
		}
		if (writev(fd, iov, 2) != 2) {
			perror("pwrite");
			do_exit(1);
		}
	}
	exit(0);
}
