#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>

char dbuf[40960];

void usage(void)
{
	fprintf(stderr, "Usage: create-delete-data dirname\n");
	exit(1);
}

#define NR 50

int main(int argc, char *argv[])
{
	char *dirname;
	int i;

	if (argc != 2)
		usage();
	dirname = argv[1];
	if (chdir(dirname)) {
		perror("create-delete-data: chdir");
		exit(1);
	}

	for ( ; ; ) {
		for (i = 0; i < NR; i++) {
			char buf[32];
			int fd;

			sprintf(buf, "%06d", i);
			fd = creat(buf, 0666);

			if (fd < 0) {
				perror("create-delete-data: creat");
				exit(1);
			}

			write(fd, dbuf, sizeof(dbuf));
			close(fd);
		}
		usleep(20 * 1000);
		for (i = 0; i < NR; i++) {
			char buf[32];

			sprintf(buf, "%06d", i);
			if (unlink(buf)) {
				perror("creat-delete-data: unlink");
				exit(1);
			}
		}
		printf("D");
		fflush(stdout);
	}
}
