/*
 * Copyright (C) 2001 Lorenzo Allegrucci (lenstra@tiscalinet.it)
 * Licensed under the GPL
 */
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>

#define MAX_PROCS	1024

/**
 * quick_sort - Sort in the range [l, r]
 */
void quick_sort(int a[], int l, int r)
{
	int i, j, p, tmp;
	int m, min, max;

	i = l;
	j = r;
	m = (l + r) >> 1;

	if (a[m] >= a[l]) {
		max = a[m];
		min = a[l];
	} else {
		max = a[l];
		min = a[m];
	}

	if (a[r] >= max)
		p = max;
	else {
		if (a[r] >= min)
			p = a[r];
		else
			p = min;
	}

	do {
		while (a[i] < p)
			i++;
		while (p < a[j])
			j--;
		if (i <= j) {
			tmp = a[i];
			a[i] = a[j];
			a[j] = tmp;
			i++;
			j--;
		}
	} while (i <= j);

	if (l < j)
		quick_sort(a, l, j);
	if (i < r)
		quick_sort(a, i, r);
}


void do_qsort(int n, int s)
{
	int * a, i, errors = 0;

	if ((a = malloc(sizeof(int) * n)) == NULL) {
		perror("malloc");
		exit(1);
	}

	srand(s);
	//printf("seed = %d\n", s);

	for (i = 0; i < n; i++)
		a[i] = rand();

	quick_sort(a, 0, n - 1);

	//printf("verify... "); fflush(stdout);
	for (i = 0; i < n - 1; i++)
		if (a[i] > a[i + 1])
			errors++;
	//printf("done.\n");
	if (errors)
		fprintf(stderr, "WARNING: %d errors.\n", errors);
	free(a);
	exit(0);
}


void start_procs(int n, int p, int s)
{
	int i, pid[MAX_PROCS];
	int status;

	if (p > MAX_PROCS)
		p = MAX_PROCS;

	for (i = 0; i < p; i++) {
		pid[i] = fork();
		if (pid[i] == 0)
			do_qsort(n, s);
		else if (pid[i] < 0)
			perror("fork");
	}

	for (i = 0; i < p; i++)
		waitpid(pid[i], &status, 0);
}

void usage(void)
{
	fprintf(stderr, "Usage: qs [-h] [-n nr_elems] [-p nr_procs]"
			" [-s seed]\n");
	exit(1);
}


int main(int argc, char * argv[])
{
	char *n = "1000000", *p = "1", *s = "1";
	int nr_elems, nr_procs, seed;
	int c;

	if (argc == 1)
		usage();

	while (1) {
		c = getopt(argc, argv, "hn:p:s:V");
		if (c == -1)
			break;

		switch (c) {
		case 'h':
			usage();
		case 'n':
			n = optarg;
			break;
		case 'p':
			p = optarg;
			break;
		case 's':
			s = optarg;
			break;
		case 'V':
			printf("Version 0.93\n");
			return 1;
		case '?':
			return 1;
		}
	}

	nr_elems = atoi(n);
	nr_procs = atoi(p);
	seed = atoi(s);
	start_procs(nr_elems, nr_procs, seed);

	return 0;
}
