/*
 * Do lots of random reads, then go linear
 */

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <limits.h>
#include <sys/stat.h>

#include "fadvise.h"

char *progname;

ssize_t pread(int fd, void *buf, size_t count, off_t offset);

void usage(void)
{
	fprintf(stderr, "Usage: %s filename\n", progname);
	exit(1);
}

int main(int argc, char *argv[])
{
	int c;
	int fd;
	char *filename;
	struct stat statbuf;
	off_t size;
	int i;
	char *p = memalign(4096, 4096);

	progname = argv[0];
	while ((c = getopt(argc, argv, "")) != -1) {
		switch (c) {
		default:
			usage();
			break;
		}
	}

	if (optind == argc)
		usage();
	filename = argv[optind++];

	if (optind != argc)
		usage();

	fd = open(filename, O_RDONLY);
	if (fd < 0) {
		perror("open");
		exit(1);
	}

	fstat(fd, &statbuf);
	if (S_ISBLK(statbuf.st_mode)) {
		size = INT_MAX;
	} else {
		size = statbuf.st_size;
	}

	fsync(fd);
	__posix_fadvise64(fd, 0, size, POSIX_FADV_DONTNEED);

	srand(getpid());
	size /= 2;

	/* Some linear reads to build up the readahead window */
	lseek(fd, 0, SEEK_SET);
	for (i = 0; i < 128; i++)
		read(fd, p, 4096);

	/* Seeky reads to turn off readahead */
	for (i = 0; i < 128; i++) {
		off_t offset;
		int ret;

		offset = rand() % size;
		ret = pread(fd, p, 4096, offset & ~4095);
		if (ret != 4096) {
			perror("pread");
			fprintf(stderr, "pread at %ld returned %d\n",
					(long)offset, ret);
			exit(1);
		}
	}

	/* Linear reads to build it up again */
	lseek(fd, size, SEEK_SET);
	for (i = 0; i < 128; i++)
		read(fd, p, 4096);

	/* re-reads to turn off readahead */
	lseek(fd, size, SEEK_SET);
	for (i = 0; i < 128; i++)
		read(fd, p, 4096);

	/* Uncached reads to start it again */
	lseek(fd, size + 128 * 4096, SEEK_SET);
	for (i = 0; i < 128; i++)
		read(fd, p, 4096);

	exit(0);
}
