#!/bin/sh
#
# Test journal_flushpage for page leaks.
#
# The current directory must be an ext3 directory, on an fs which is
# mounted in journalled data mode.
#
# What we do is to generate 1000 dirty pages against the journal,
# wait until a commit happens and then unlink the file.  That will
# cause all the buffers (which are in checkpoint mode) to be cleaned
# and attached to the unlink's transaction's forget list.  When the
# unlink transaction commits, all the buffers (and hence their pages)
# should be dropped.
#
# We use `sync' after the unlink to hurry the unlink's commit along a bit.
#
# If JBD is leaking pages in this test, it'll leak 1000 per iteration. So
# just run the script until you're convinced.
#

PAGES_PER_LOOP=1000
PAGES_DONE=0
PAGE_SIZE=4096

while true
do
	dd if=/dev/zero of=foo bs=$PAGE_SIZE count=$PAGES_PER_LOOP
	sleep 6
	rm foo
	sync
	sleep 1
	PAGES_DONE=$(expr $PAGES_DONE + $PAGES_PER_LOOP)
	echo "Pages done: $PAGES_DONE"
done
