/*
 * Wait for an ext3 filesystem to go readonly
 *
 * Need I point out the obvious?
 *
 * 17May01	Andrew Morton <andrewm@uow.edu.au>
 *	Created
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/errno.h>
#include <sys/fcntl.h>

#ifndef EXT3_IOC_WAIT_FOR_READONLY
#define EXT3_IOC_WAIT_FOR_READONLY	_IOR('f', 99, long)
#endif

static void usage(void)
{
	fprintf(stderr, "Usage: wait-for-readonly /mnt/mountpoint\n");
	exit(1);
}

int main(int argc, char *argv[])
{
	char *name;
	int fd;
	int ret;

	if (argc != 2)
		usage();
	name = argv[1];

	fd = open(name, O_RDONLY);
	if (fd < 0) {
		fprintf(stderr, "%s: cannot open `%s' for reading: %s\n",
			argv[0], name, strerror(errno));
		exit(1);
	}
	ret = ioctl(fd, EXT3_IOC_WAIT_FOR_READONLY, 0);
	if (ret < 0) {
		fprintf(stderr, "%s: ioctl(%s, EXT3_IOC_WAIT_FOR_READONLY failed: %s\n",
			argv[0], name, strerror(errno));
		exit(1);
	}
	close(fd);
	exit(0);
}

