/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.graphics.Rect;
import android.os.Build;
import android.support.v4.view.WindowInsetsCompatApi20;
import android.support.v4.view.WindowInsetsCompatApi21;

public class WindowInsetsCompat {
    private static final WindowInsetsCompatImpl IMPL;
    private final Object mInsets;

    private WindowInsetsCompat(Object insets) {
        this.mInsets = insets;
    }

    public WindowInsetsCompat(WindowInsetsCompat src) {
        this.mInsets = src == null ? null : IMPL.getSourceWindowInsets(src.mInsets);
    }

    public int getSystemWindowInsetLeft() {
        return IMPL.getSystemWindowInsetLeft(this.mInsets);
    }

    public int getSystemWindowInsetTop() {
        return IMPL.getSystemWindowInsetTop(this.mInsets);
    }

    public int getSystemWindowInsetRight() {
        return IMPL.getSystemWindowInsetRight(this.mInsets);
    }

    public int getSystemWindowInsetBottom() {
        return IMPL.getSystemWindowInsetBottom(this.mInsets);
    }

    public boolean hasSystemWindowInsets() {
        return IMPL.hasSystemWindowInsets(this.mInsets);
    }

    public boolean hasInsets() {
        return IMPL.hasInsets(this.mInsets);
    }

    public boolean isConsumed() {
        return IMPL.isConsumed(this.mInsets);
    }

    public boolean isRound() {
        return IMPL.isRound(this.mInsets);
    }

    public WindowInsetsCompat consumeSystemWindowInsets() {
        return IMPL.consumeSystemWindowInsets(this.mInsets);
    }

    public WindowInsetsCompat replaceSystemWindowInsets(int left, int top, int right, int bottom) {
        return IMPL.replaceSystemWindowInsets(this.mInsets, left, top, right, bottom);
    }

    public WindowInsetsCompat replaceSystemWindowInsets(Rect systemWindowInsets) {
        return IMPL.replaceSystemWindowInsets(this.mInsets, systemWindowInsets);
    }

    public int getStableInsetTop() {
        return IMPL.getStableInsetTop(this.mInsets);
    }

    public int getStableInsetLeft() {
        return IMPL.getStableInsetLeft(this.mInsets);
    }

    public int getStableInsetRight() {
        return IMPL.getStableInsetRight(this.mInsets);
    }

    public int getStableInsetBottom() {
        return IMPL.getStableInsetBottom(this.mInsets);
    }

    public boolean hasStableInsets() {
        return IMPL.hasStableInsets(this.mInsets);
    }

    public WindowInsetsCompat consumeStableInsets() {
        return IMPL.consumeStableInsets(this.mInsets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowInsetsCompat other = (WindowInsetsCompat)o;
        return this.mInsets == null ? other.mInsets == null : this.mInsets.equals(other.mInsets);
    }

    public int hashCode() {
        return this.mInsets == null ? 0 : this.mInsets.hashCode();
    }

    static WindowInsetsCompat wrap(Object insets) {
        return insets == null ? null : new WindowInsetsCompat(insets);
    }

    static Object unwrap(WindowInsetsCompat insets) {
        return insets == null ? null : insets.mInsets;
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new WindowInsetsCompatApi21Impl() : (version >= 20 ? new WindowInsetsCompatApi20Impl() : new WindowInsetsCompatBaseImpl());
    }

    private static class WindowInsetsCompatApi21Impl
    extends WindowInsetsCompatApi20Impl {
        private WindowInsetsCompatApi21Impl() {
        }

        @Override
        public WindowInsetsCompat consumeStableInsets(Object insets) {
            return new WindowInsetsCompat(WindowInsetsCompatApi21.consumeStableInsets((Object)insets));
        }

        @Override
        public int getStableInsetBottom(Object insets) {
            return WindowInsetsCompatApi21.getStableInsetBottom((Object)insets);
        }

        @Override
        public int getStableInsetLeft(Object insets) {
            return WindowInsetsCompatApi21.getStableInsetLeft((Object)insets);
        }

        @Override
        public int getStableInsetRight(Object insets) {
            return WindowInsetsCompatApi21.getStableInsetRight((Object)insets);
        }

        @Override
        public int getStableInsetTop(Object insets) {
            return WindowInsetsCompatApi21.getStableInsetTop((Object)insets);
        }

        @Override
        public boolean hasStableInsets(Object insets) {
            return WindowInsetsCompatApi21.hasStableInsets((Object)insets);
        }

        @Override
        public boolean isConsumed(Object insets) {
            return WindowInsetsCompatApi21.isConsumed((Object)insets);
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object insets, Rect systemWindowInsets) {
            return new WindowInsetsCompat(WindowInsetsCompatApi21.replaceSystemWindowInsets((Object)insets, (Rect)systemWindowInsets));
        }
    }

    private static class WindowInsetsCompatApi20Impl
    extends WindowInsetsCompatBaseImpl {
        private WindowInsetsCompatApi20Impl() {
        }

        @Override
        public WindowInsetsCompat consumeSystemWindowInsets(Object insets) {
            return new WindowInsetsCompat(WindowInsetsCompatApi20.consumeSystemWindowInsets((Object)insets));
        }

        @Override
        public int getSystemWindowInsetBottom(Object insets) {
            return WindowInsetsCompatApi20.getSystemWindowInsetBottom((Object)insets);
        }

        @Override
        public int getSystemWindowInsetLeft(Object insets) {
            return WindowInsetsCompatApi20.getSystemWindowInsetLeft((Object)insets);
        }

        @Override
        public int getSystemWindowInsetRight(Object insets) {
            return WindowInsetsCompatApi20.getSystemWindowInsetRight((Object)insets);
        }

        @Override
        public int getSystemWindowInsetTop(Object insets) {
            return WindowInsetsCompatApi20.getSystemWindowInsetTop((Object)insets);
        }

        @Override
        public boolean hasInsets(Object insets) {
            return WindowInsetsCompatApi20.hasInsets((Object)insets);
        }

        @Override
        public boolean hasSystemWindowInsets(Object insets) {
            return WindowInsetsCompatApi20.hasSystemWindowInsets((Object)insets);
        }

        @Override
        public boolean isRound(Object insets) {
            return WindowInsetsCompatApi20.isRound((Object)insets);
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object insets, int left, int top, int right, int bottom) {
            return new WindowInsetsCompat(WindowInsetsCompatApi20.replaceSystemWindowInsets((Object)insets, (int)left, (int)top, (int)right, (int)bottom));
        }

        @Override
        public Object getSourceWindowInsets(Object src) {
            return WindowInsetsCompatApi20.getSourceWindowInsets((Object)src);
        }
    }

    private static class WindowInsetsCompatBaseImpl
    implements WindowInsetsCompatImpl {
        private WindowInsetsCompatBaseImpl() {
        }

        @Override
        public int getSystemWindowInsetLeft(Object insets) {
            return 0;
        }

        @Override
        public int getSystemWindowInsetTop(Object insets) {
            return 0;
        }

        @Override
        public int getSystemWindowInsetRight(Object insets) {
            return 0;
        }

        @Override
        public int getSystemWindowInsetBottom(Object insets) {
            return 0;
        }

        @Override
        public boolean hasSystemWindowInsets(Object insets) {
            return false;
        }

        @Override
        public boolean hasInsets(Object insets) {
            return false;
        }

        @Override
        public boolean isConsumed(Object insets) {
            return false;
        }

        @Override
        public boolean isRound(Object insets) {
            return false;
        }

        @Override
        public WindowInsetsCompat consumeSystemWindowInsets(Object insets) {
            return null;
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object insets, int left, int top, int right, int bottom) {
            return null;
        }

        @Override
        public WindowInsetsCompat replaceSystemWindowInsets(Object insets, Rect systemWindowInsets) {
            return null;
        }

        @Override
        public int getStableInsetTop(Object insets) {
            return 0;
        }

        @Override
        public int getStableInsetLeft(Object insets) {
            return 0;
        }

        @Override
        public int getStableInsetRight(Object insets) {
            return 0;
        }

        @Override
        public int getStableInsetBottom(Object insets) {
            return 0;
        }

        @Override
        public boolean hasStableInsets(Object insets) {
            return false;
        }

        @Override
        public WindowInsetsCompat consumeStableInsets(Object insets) {
            return null;
        }

        @Override
        public Object getSourceWindowInsets(Object src) {
            return null;
        }
    }

    private static interface WindowInsetsCompatImpl {
        public int getSystemWindowInsetLeft(Object var1);

        public int getSystemWindowInsetTop(Object var1);

        public int getSystemWindowInsetRight(Object var1);

        public int getSystemWindowInsetBottom(Object var1);

        public boolean hasSystemWindowInsets(Object var1);

        public boolean hasInsets(Object var1);

        public boolean isConsumed(Object var1);

        public boolean isRound(Object var1);

        public WindowInsetsCompat consumeSystemWindowInsets(Object var1);

        public WindowInsetsCompat replaceSystemWindowInsets(Object var1, int var2, int var3, int var4, int var5);

        public WindowInsetsCompat replaceSystemWindowInsets(Object var1, Rect var2);

        public int getStableInsetTop(Object var1);

        public int getStableInsetLeft(Object var1);

        public int getStableInsetRight(Object var1);

        public int getStableInsetBottom(Object var1);

        public boolean hasStableInsets(Object var1);

        public WindowInsetsCompat consumeStableInsets(Object var1);

        public Object getSourceWindowInsets(Object var1);
    }
}

