/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzjm;
import com.google.android.gms.internal.firebase-auth-api.zzki;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzjo
implements zzki {
    private static final int[] zzb;
    int[] zza;
    private final int zzc;

    zzjo(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            Object object = new InvalidKeyException("The key length in bytes must be 32.");
            throw object;
        }
        ((zzjo)object).zza = zzjo.zzi(byArray);
        ((zzjo)object).zzc = n;
    }

    abstract int[] zzb(int[] var1, int var2);

    abstract int zzc();

    @Override
    public final byte[] zza(byte[] byArray) throws GeneralSecurityException {
        return this.zzd(ByteBuffer.wrap(byArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    final byte[] zzd(ByteBuffer byteBuffer) throws GeneralSecurityException {
        if (byteBuffer.remaining() < ((zzjo)object).zzc()) {
            Object object = new GeneralSecurityException("ciphertext too short");
            throw object;
        }
        byte[] byArray = new byte[((zzjo)object).zzc()];
        byteBuffer.get(byArray);
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        int n = byteBuffer.remaining();
        int n2 = n / 64 + 1;
        int n3 = 0;
        while (n3 < n2) {
            ByteBuffer byteBuffer3 = ((zzjo)object).zze(byArray, n3 + ((zzjo)object).zzc);
            if (n3 == n2 + -1) {
                zzjm.zzd(byteBuffer2, byteBuffer, byteBuffer3, n % 64);
            } else {
                zzjm.zzd(byteBuffer2, byteBuffer, byteBuffer3, 64);
            }
            ++n3;
        }
        return byteBuffer2.array();
    }

    final ByteBuffer zze(byte[] objectArray, int n) {
        objectArray = this.zzb(zzjo.zzi(objectArray), n);
        int[] nArray = (int[])objectArray.clone();
        zzjo.zzg(nArray);
        for (int i = 0; i < 16; ++i) {
            objectArray[i] = objectArray[i] + nArray[i];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put((int[])objectArray, 0, 16);
        return byteBuffer;
    }

    static void zzf(int[] nArray, int[] nArray2) {
        System.arraycopy(zzb, 0, nArray, 0, zzb.length);
        System.arraycopy(nArray2, 0, nArray, zzb.length, 8);
    }

    static void zzg(int[] nArray) {
        for (int i = 0; i < 10; ++i) {
            zzjo.zzh(nArray, 0, 4, 8, 12);
            zzjo.zzh(nArray, 1, 5, 9, 13);
            zzjo.zzh(nArray, 2, 6, 10, 14);
            zzjo.zzh(nArray, 3, 7, 11, 15);
            zzjo.zzh(nArray, 0, 5, 10, 15);
            zzjo.zzh(nArray, 1, 6, 11, 12);
            zzjo.zzh(nArray, 2, 7, 8, 13);
            zzjo.zzh(nArray, 3, 4, 9, 14);
        }
    }

    static void zzh(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        nArray[n] = n5 = nArray[n] + nArray[n2];
        n5 = nArray[n4] ^ n5;
        nArray[n4] = n5 = n5 << 16 | n5 >>> -16;
        nArray[n3] = n5 = nArray[n3] + n5;
        n5 = nArray[n2] ^ n5;
        nArray[n2] = n5 = n5 << 12 | n5 >>> -12;
        nArray[n] = n5 = nArray[n] + n5;
        n = nArray[n4] ^ n5;
        nArray[n4] = n = n << 8 | n >>> -8;
        nArray[n3] = n = nArray[n3] + n;
        n = nArray[n2] ^ n;
        nArray[n2] = n << 7 | n >>> -7;
    }

    static int[] zzi(byte[] object) {
        object = ByteBuffer.wrap((byte[])object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[((Buffer)object).remaining()];
        ((IntBuffer)object).get(nArray);
        return nArray;
    }

    static {
        byte[] byArray = new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107};
        zzb = zzjo.zzi(byArray);
    }
}

