/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzaf;
import com.google.android.gms.internal.firebase-auth-api.zzh;
import com.google.android.gms.internal.firebase-auth-api.zzq;
import com.google.android.gms.internal.firebase-auth-api.zztb;
import com.google.android.gms.internal.firebase-auth-api.zzuy;
import com.google.android.gms.internal.firebase-auth-api.zzuz;
import com.google.android.gms.internal.firebase-auth-api.zzvb;
import com.google.android.gms.internal.firebase-auth-api.zzvc;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzvd {
    private static final Logger zza;
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap<String, zzvc> zzd;

    zzvd(@NonNull Context context) {
        HashMap hashMap = new HashMap();
        this.zzd = hashMap;
        this.zzb = (Context)Preconditions.checkNotNull((Object)context);
        zzh.zza();
        this.zzc = Executors.unconfigurableScheduledExecutorService(Executors.newScheduledThreadPool(1));
    }

    final boolean zza(String string) {
        return this.zzd.get(string) != null;
    }

    final void zzb(String string, zztb object, long l, boolean bl) {
        Object object2 = this.zzd;
        zzvc zzvc2 = new zzvc(l, bl);
        ((HashMap)object2).put((String)string, (zzvc)zzvc2);
        this.zzc((zztb)object, string);
        object = this.zzd.get(string);
        if (((zzvc)object).zza <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        ScheduledExecutorService scheduledExecutorService = this.zzc;
        object2 = new zzuy(this, string);
        ((zzvc)object).zzf = scheduledExecutorService.schedule((Runnable)object2, ((zzvc)object).zza, TimeUnit.SECONDS);
        if (!((zzvc)object).zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        object = new zzvb(this, string);
        string = new IntentFilter();
        string.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        this.zzb.getApplicationContext().registerReceiver((BroadcastReceiver)object, (IntentFilter)string);
        string = this.zzb;
        string = SmsRetriever.getClient((Context)string);
        string = string.startSmsRetriever();
        object = new zzuz(this);
        string.addOnFailureListener((OnFailureListener)object);
    }

    final void zzc(zztb zztb2, String string) {
        zzvc zzvc2 = ((zzvd)((Object)zzvc2)).zzd.get(string);
        if (zzvc2 == null) {
            return;
        }
        zzvc2.zzb.add(zztb2);
        if (zzvc2.zzg) {
            zztb2.zzh(zzvc2.zzd);
        }
        if (zzvc2.zzh) {
            zztb2.zzi(PhoneAuthCredential.zzb(zzvc2.zzd, zzvc2.zze));
        }
        if (zzvc2.zzi) {
            zztb2.zzj(zzvc2.zzd);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String zzd() {
        try {
            void var0_3;
            String string;
            String string2 = this.zzb.getPackageName();
            int n = Build.VERSION.SDK_INT;
            if (n < 28) {
                Context context = this.zzb;
                Signature[] signatureArray = Wrappers.packageManager((Context)context).getPackageInfo((String)string2, (int)64).signatures;
            } else {
                Context context = this.zzb;
                Signature[] signatureArray = Wrappers.packageManager((Context)context).getPackageInfo((String)string2, (int)0x8000000).signingInfo.getApkContentsSigners();
            }
            if ((string = zzvd.zzm(string2, var0_3[0].toCharsString())) != null) {
                return string;
            }
            zza.e("Hash generation failed.", new Object[0]);
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String zzm(String string, String object) {
        MessageDigest messageDigest;
        String string2 = String.valueOf(string);
        int n = string2.length();
        String string3 = String.valueOf(object);
        int n2 = string3.length();
        StringBuilder stringBuilder = new StringBuilder(n + 1 + n2);
        stringBuilder.append(string);
        stringBuilder.append(" ");
        stringBuilder.append((String)object);
        object = stringBuilder.toString();
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(((String)object).getBytes(zzq.zzc));
            object = Arrays.copyOf(messageDigest.digest(), 9);
            object = Base64.encodeToString((byte[])object, (int)3).substring(0, 11);
            messageDigest = zza;
            n2 = String.valueOf(string).length();
            n2 += 19;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            object = zza;
            String string4 = String.valueOf(noSuchAlgorithmException.getMessage());
            String string5 = "NoSuchAlgorithm: ";
            string4 = string4.length() != 0 ? string5.concat(string4) : new String(string5);
            object.e(string4, new Object[0]);
            return null;
        }
        {
            int n3 = String.valueOf(object).length();
            StringBuilder stringBuilder2 = new StringBuilder(n2 += n3);
            stringBuilder2.append("Package: ");
            stringBuilder2.append(string);
            stringBuilder2.append(" -- Hash: ");
            stringBuilder2.append((String)object);
            messageDigest.d(stringBuilder2.toString(), new Object[0]);
            return object;
        }
    }

    private final void zzn(String string) {
        zzvc zzvc2 = this.zzd.get(string);
        if (zzvc2 == null) {
            return;
        }
        if (!zzvc2.zzi) {
            this.zzo(string);
        }
        this.zze(string);
    }

    private final void zzo(String object) {
        zzvc zzvc2 = ((zzvd)((Object)zzvc2)).zzd.get(object);
        if (zzvc2 == null) {
            return;
        }
        if (!zzvc2.zzh && !zzaf.zzb(zzvc2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            object = zzvc2.zzb.iterator();
            while (object.hasNext()) {
                ((zztb)object.next()).zzj(zzvc2.zzd);
            }
            zzvc2.zzi = true;
            return;
        }
    }

    final void zze(String string) {
        zzvc zzvc2 = this.zzd.get(string);
        if (zzvc2 == null) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = zzvc2.zzf;
        if (scheduledFuture != null && !scheduledFuture.isDone()) {
            zzvc2.zzf.cancel(false);
        }
        zzvc2.zzb.clear();
        this.zzd.remove(string);
    }

    @VisibleForTesting
    static String zzf(String object) {
        object = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher((CharSequence)object);
        if (((Matcher)object).find()) {
            return ((Matcher)object).group();
        }
        return null;
    }

    final /* synthetic */ void zzg(String string) {
        this.zzn(string);
    }

    static /* synthetic */ Logger zzh() {
        return zza;
    }

    static /* synthetic */ HashMap zzi(zzvd zzvd2) {
        return zzvd2.zzd;
    }

    static /* synthetic */ void zzj(zzvd object, String object2) {
        object = ((zzvd)object).zzd.get(object2);
        if (object == null || zzaf.zzb(((zzvc)object).zzd) || zzaf.zzb(((zzvc)object).zze) || ((zzvc)object).zzb.isEmpty()) {
            return;
        }
        object2 = ((zzvc)object).zzb.iterator();
        while (object2.hasNext()) {
            ((zztb)object2.next()).zzi(PhoneAuthCredential.zzb(((zzvc)object).zzd, ((zzvc)object).zze));
        }
        ((zzvc)object).zzh = true;
    }

    static /* synthetic */ void zzk(zzvd zzvd2, String string) {
        zzvd2.zzn(string);
    }

    static /* synthetic */ void zzl(zzvd zzvd2, String string) {
        zzvd2.zzo(string);
    }

    static {
        Logger logger;
        String[] stringArray = new String[]{"SmsRetrieverHelper"};
        zza = logger = new Logger("FirebaseAuth", stringArray);
    }
}

