/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zzg;

@SafeParcelable.Class(creator="EmailAuthCredentialCreator")
public class EmailAuthCredential
extends AuthCredential {
    public static final Parcelable.Creator<EmailAuthCredential> CREATOR;
    @SafeParcelable.Field(id=1, getter="getEmail")
    private String zza;
    @SafeParcelable.Field(id=2, getter="getPassword")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getSignInLink")
    private final String zzc;
    @SafeParcelable.Field(id=4, getter="getCachedState")
    private String zzd;
    @SafeParcelable.Field(id=5, getter="isForLinking")
    private boolean zze;

    /*
     * WARNING - void declaration
     */
    @SafeParcelable.Constructor
    EmailAuthCredential(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) @NonNull String string2, @SafeParcelable.Param(id=3) @NonNull String string3, @SafeParcelable.Param(id=4) @NonNull String string4, @SafeParcelable.Param(id=5) @NonNull boolean bl) {
        void var5_6;
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_2;
        this.zza = Preconditions.checkNotEmpty((String)var1_2);
        if (TextUtils.isEmpty((CharSequence)var2_3) && TextUtils.isEmpty((CharSequence)var3_4)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create an EmailAuthCredential without a password or emailLink.");
            throw illegalArgumentException;
        }
        this.zzb = var2_3;
        this.zzc = var3_4;
        this.zzd = var4_5;
        this.zze = var5_6;
    }

    @Override
    @NonNull
    public String getProvider() {
        return "password";
    }

    @Override
    @NonNull
    public String getSignInMethod() {
        if (!TextUtils.isEmpty((CharSequence)this.zzb)) {
            return "password";
        }
        return "emailLink";
    }

    public final void writeToParcel(Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)1, (String)this.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)4, (String)this.zzd, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel, (int)5, (boolean)this.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    static {
        zzg zzg2;
        CREATOR = zzg2 = new zzg();
    }

    @NonNull
    public final String zzb() {
        return this.zza;
    }

    @NonNull
    public final String zzc() {
        return this.zzb;
    }

    @NonNull
    public final String zzd() {
        return this.zzc;
    }

    @Nullable
    public final String zze() {
        return this.zzd;
    }

    public final boolean zzf() {
        return this.zze;
    }

    public final EmailAuthCredential zzg(@Nullable FirebaseUser firebaseUser) {
        this.zzd = firebaseUser.zzg();
        this.zze = true;
        return this;
    }

    public final boolean zzh() {
        return !TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public static boolean zzi(@NonNull String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        return (object = ActionCodeUrl.parseLink((String)object)) != null && ((ActionCodeUrl)object).getOperation() == 4;
    }

    @Override
    public final AuthCredential zza() {
        EmailAuthCredential emailAuthCredential = new EmailAuthCredential(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
        return emailAuthCredential;
    }
}

