/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.tasks.Task;
import com.google.firebase.functions.FirebaseFunctions;
import com.google.firebase.functions.HttpsCallOptions;
import com.google.firebase.functions.HttpsCallableResult;
import java.util.concurrent.TimeUnit;

public class HttpsCallableReference {
    private final FirebaseFunctions functionsClient;
    private final String name;
    HttpsCallOptions options = new HttpsCallOptions();

    HttpsCallableReference(FirebaseFunctions functionsClient, String name) {
        this.functionsClient = functionsClient;
        this.name = name;
    }

    @NonNull
    public Task<HttpsCallableResult> call(@Nullable Object data) {
        return this.functionsClient.call(this.name, data, this.options);
    }

    @NonNull
    public Task<HttpsCallableResult> call() {
        return this.functionsClient.call(this.name, null, this.options);
    }

    public void setTimeout(long timeout, @NonNull TimeUnit units) {
        this.options.setTimeout(timeout, units);
    }

    public long getTimeout() {
        return this.options.getTimeout();
    }

    @NonNull
    public HttpsCallableReference withTimeout(long timeout, @NonNull TimeUnit units) {
        HttpsCallableReference other = new HttpsCallableReference(this.functionsClient, this.name);
        other.setTimeout(timeout, units);
        return other;
    }
}

