/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.functions;

import androidx.annotation.VisibleForTesting;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Serializer {
    @VisibleForTesting
    static final String LONG_TYPE = "type.googleapis.com/google.protobuf.Int64Value";
    @VisibleForTesting
    static final String UNSIGNED_LONG_TYPE = "type.googleapis.com/google.protobuf.UInt64Value";
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);

    public Serializer() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public Object encode(Object obj) {
        if (obj == null || obj == JSONObject.NULL) {
            return JSONObject.NULL;
        }
        if (obj instanceof Long) {
            JSONObject wrapped = new JSONObject();
            try {
                wrapped.put("@type", (Object)LONG_TYPE);
                wrapped.put("value", (Object)obj.toString());
            }
            catch (JSONException e) {
                throw new RuntimeException("Error encoding Long.", e);
            }
            return wrapped;
        }
        if (obj instanceof Number) {
            return obj;
        }
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof JSONObject) {
            return obj;
        }
        if (obj instanceof JSONArray) {
            return obj;
        }
        if (obj instanceof Map) {
            JSONObject result = new JSONObject();
            Map m = (Map)obj;
            for (Object k : m.keySet()) {
                if (!(k instanceof String)) {
                    throw new IllegalArgumentException("Object keys must be strings.");
                }
                String key = (String)k;
                Object value = this.encode(m.get(k));
                try {
                    result.put(key, value);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }
        if (obj instanceof List) {
            JSONArray result = new JSONArray();
            List l = (List)obj;
            for (Object o : l) {
                result.put(this.encode(o));
            }
            return result;
        }
        if (obj instanceof JSONObject) {
            JSONObject result = new JSONObject();
            JSONObject m = (JSONObject)obj;
            Iterator keys = m.keys();
            while (keys.hasNext()) {
                String k = (String)keys.next();
                if (k == null) {
                    throw new IllegalArgumentException("Object keys cannot be null.");
                }
                String key = k;
                Object value = this.encode(m.opt(k));
                try {
                    result.put(key, value);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return result;
        }
        if (obj instanceof JSONArray) {
            JSONArray result = new JSONArray();
            JSONArray l = (JSONArray)obj;
            for (int i = 0; i < l.length(); ++i) {
                Object o = l.opt(i);
                result.put(this.encode(o));
            }
            return result;
        }
        throw new IllegalArgumentException("Object cannot be encoded in JSON: " + obj);
    }

    public Object decode(Object obj) {
        if (obj instanceof Number) {
            return obj;
        }
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof Boolean) {
            return obj;
        }
        if (obj instanceof JSONObject) {
            if (((JSONObject)obj).has("@type")) {
                String type = ((JSONObject)obj).optString("@type");
                String value = ((JSONObject)obj).optString("value");
                if (type.equals(LONG_TYPE)) {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid Long format:" + value);
                    }
                }
                if (type.equals(UNSIGNED_LONG_TYPE)) {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid Long format:" + value);
                    }
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            Iterator keys = ((JSONObject)obj).keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = this.decode(((JSONObject)obj).opt(key));
                result.put(key, value);
            }
            return result;
        }
        if (obj instanceof JSONArray) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < ((JSONArray)obj).length(); ++i) {
                Object value = this.decode(((JSONArray)obj).opt(i));
                result.add(value);
            }
            return result;
        }
        if (obj == JSONObject.NULL) {
            return null;
        }
        throw new IllegalArgumentException("Object cannot be decoded from JSON: " + obj);
    }
}

