/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.AnyThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.cloudmessaging.Rpc;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.GmsRpc$$Lambda$0;
import com.google.firebase.iid.Metadata;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@KeepForSdk
public class GmsRpc {
    @KeepForSdk
    public static final String ERROR_SERVICE_NOT_AVAILABLE = "SERVICE_NOT_AVAILABLE";
    @KeepForSdk
    public static final String ERROR_INTERNAL_SERVER_ERROR = "INTERNAL_SERVER_ERROR";
    private final FirebaseApp app;
    private final Metadata metadata;
    private final Rpc rpc;
    private final Provider<UserAgentPublisher> userAgentPublisher;
    private final Provider<HeartBeatInfo> heartbeatInfo;
    private final FirebaseInstallationsApi firebaseInstallations;

    public GmsRpc(FirebaseApp firebaseApp, Metadata metadata, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        Rpc rpc = new Rpc(firebaseApp.getApplicationContext());
        this(firebaseApp, metadata, rpc, provider, provider2, firebaseInstallationsApi);
    }

    @VisibleForTesting
    GmsRpc(FirebaseApp firebaseApp, Metadata metadata, Rpc rpc, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        this.app = firebaseApp;
        this.metadata = metadata;
        this.rpc = rpc;
        this.userAgentPublisher = provider;
        this.heartbeatInfo = provider2;
        this.firebaseInstallations = firebaseInstallationsApi;
    }

    public Task<String> getToken(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        return this.extractResponseWhenComplete(this.startRpc(string, string2, string3, bundle));
    }

    public Task<?> deleteToken(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        bundle.putString("delete", "1");
        return this.extractResponseWhenComplete(this.startRpc(string, string2, string3, bundle));
    }

    public Task<?> deleteInstanceId(String string) {
        Bundle bundle = new Bundle();
        bundle.putString("iid-operation", "delete");
        bundle.putString("delete", "1");
        return this.extractResponseWhenComplete(this.startRpc(string, "*", "*", bundle));
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public Task<?> subscribeToTopic(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf(string3);
        String string5 = "/topics/";
        string4 = string4.length() != 0 ? string5.concat(string4) : new String(string5);
        bundle.putString("gcm.topic", string4);
        string3 = String.valueOf(string3);
        string4 = "/topics/";
        if (string3.length() != 0) {
            string3 = string4.concat(string3);
            return this.extractResponseWhenComplete(this.startRpc(string, string2, string3, bundle));
        }
        string3 = new String(string4);
        return this.extractResponseWhenComplete(this.startRpc(string, string2, string3, bundle));
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public Task<?> unsubscribeFromTopic(String string, String string2, String string3) {
        Bundle bundle = new Bundle();
        String string4 = String.valueOf(string3);
        String string5 = "/topics/";
        string4 = string4.length() != 0 ? string5.concat(string4) : new String(string5);
        bundle.putString("gcm.topic", string4);
        bundle.putString("delete", "1");
        string3 = String.valueOf(string3);
        string4 = "/topics/";
        if (string3.length() != 0) {
            string3 = string4.concat(string3);
            return this.extractResponseWhenComplete(this.startRpc(string, string2, string3, bundle));
        }
        string3 = new String(string4);
        return this.extractResponseWhenComplete(this.startRpc(string, string2, string3, bundle));
    }

    private Task<Bundle> startRpc(String string, String string2, String string3, Bundle bundle) {
        this.setDefaultAttributesToBundle(string, string2, string3, bundle);
        return this.rpc.send(bundle);
    }

    private static String base64UrlSafe(byte[] byArray) {
        return Base64.encodeToString((byte[])byArray, (int)11);
    }

    private String getHashedFirebaseAppName() {
        Object object = ((GmsRpc)object).app.getName();
        String string = "SHA-1";
        try {
            object = GmsRpc.base64UrlSafe(MessageDigest.getInstance(string).digest(((String)object).getBytes()));
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "[HASH-ERROR]";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bundle setDefaultAttributesToBundle(String string, String string2, String string3, Bundle bundle) {
        block4: {
            bundle.putString("scope", string3);
            bundle.putString("sender", string2);
            bundle.putString("subtype", string2);
            bundle.putString("appid", string);
            bundle.putString("gmp_app_id", gmsRpc.app.getOptions().getApplicationId());
            bundle.putString("gmsv", Integer.toString(gmsRpc.metadata.getGmsVersionCode()));
            bundle.putString("osv", Integer.toString(Build.VERSION.SDK_INT));
            bundle.putString("app_ver", gmsRpc.metadata.getAppVersionCode());
            bundle.putString("app_ver_name", gmsRpc.metadata.getAppVersionName());
            bundle.putString("firebase-app-name-hash", gmsRpc.getHashedFirebaseAppName());
            string = gmsRpc.firebaseInstallations.getToken(false);
            string = ((InstallationTokenResult)Tasks.await((Task)string)).getToken();
            boolean bl = TextUtils.isEmpty((CharSequence)string);
            if (bl) break block4;
            bundle.putString("Goog-Firebase-Installations-Auth", string);
        }
        try {
            Log.w((String)"FirebaseInstanceId", (String)"FIS auth token is empty");
        }
        catch (InterruptedException | ExecutionException exception) {
            Log.e((String)"FirebaseInstanceId", (String)"Failed to get FIS auth token", (Throwable)exception);
        }
        bundle.putString("cliv", "fiid-21.0.1");
        string = (HeartBeatInfo)gmsRpc.heartbeatInfo.get();
        GmsRpc gmsRpc = (UserAgentPublisher)gmsRpc.userAgentPublisher.get();
        if (string != null && gmsRpc != null && (string = string.getHeartBeatCode("fire-iid")) != HeartBeatInfo.HeartBeat.NONE) {
            bundle.putString("Firebase-Client-Log-Type", Integer.toString(string.getCode()));
            bundle.putString("Firebase-Client", gmsRpc.getUserAgent());
        }
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    @AnyThread
    private String handleResponse(Bundle object) throws IOException {
        Object object2;
        if (object == null) {
            object2 = new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            throw object2;
        }
        object2 = object.getString("registration_id");
        if (object2 != null) {
            return object2;
        }
        object2 = object.getString("unregistered");
        if (object2 != null) {
            return object2;
        }
        object2 = object.getString("error");
        if ("RST".equals(object2)) {
            object2 = new IOException("INSTANCE_ID_RESET");
            throw object2;
        }
        if (object2 == null) {
            object2 = String.valueOf(object);
            object = String.valueOf(object2);
            int n = ((String)object).length();
            StringBuilder stringBuilder = new StringBuilder(n + 21);
            stringBuilder.append("Unexpected response: ");
            stringBuilder.append((String)object2);
            object2 = stringBuilder.toString();
            Throwable throwable = new Throwable();
            Log.w((String)"FirebaseInstanceId", (String)object2, (Throwable)throwable);
            object2 = new IOException(ERROR_SERVICE_NOT_AVAILABLE);
            throw object2;
        }
        object = new IOException((String)object2);
        throw object;
    }

    private Task<String> extractResponseWhenComplete(Task<Bundle> task) {
        Executor executor = FirebaseIidExecutors.directExecutor();
        GmsRpc$$Lambda$0 gmsRpc$$Lambda$0 = new GmsRpc$$Lambda$0(this);
        return task.continueWith(executor, (Continuation)gmsRpc$$Lambda$0);
    }

    static boolean isErrorMessageForRetryableError(String string) {
        return ERROR_SERVICE_NOT_AVAILABLE.equals(string) || ERROR_INTERNAL_SERVER_ERROR.equals(string) || "InternalServerError".equals(string);
    }

    final /* synthetic */ String lambda$extractResponseWhenComplete$0$GmsRpc(Task task) throws Exception {
        return this.handleResponse((Bundle)task.getResult(IOException.class));
    }
}

