/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations;

import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.firebase.installations.InstallationTokenResult;
import com.google.firebase.installations.StateListener;
import com.google.firebase.installations.Utils;
import com.google.firebase.installations.local.PersistedInstallationEntry;

class GetAuthTokenListener
implements StateListener {
    private final Utils utils;
    private final TaskCompletionSource<InstallationTokenResult> resultTaskCompletionSource;

    public GetAuthTokenListener(Utils utils, TaskCompletionSource<InstallationTokenResult> resultTaskCompletionSource) {
        this.utils = utils;
        this.resultTaskCompletionSource = resultTaskCompletionSource;
    }

    @Override
    public boolean onStateReached(PersistedInstallationEntry persistedInstallationEntry) {
        if (persistedInstallationEntry.isRegistered() && !this.utils.isAuthTokenExpired(persistedInstallationEntry)) {
            this.resultTaskCompletionSource.setResult((Object)InstallationTokenResult.builder().setToken(persistedInstallationEntry.getAuthToken()).setTokenExpirationTimestamp(persistedInstallationEntry.getExpiresInSecs()).setTokenCreationTimestamp(persistedInstallationEntry.getTokenCreationEpochInSecs()).build());
            return true;
        }
        return false;
    }

    @Override
    public boolean onException(Exception exception) {
        this.resultTaskCompletionSource.trySetException(exception);
        return true;
    }
}

