/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationCompat;
import com.google.android.exoplayer2.offline.Download;
import com.google.android.exoplayer2.ui.R;
import java.util.List;

public final class DownloadNotificationHelper {
    @StringRes
    private static final int NULL_STRING_ID = 0;
    private final Context context;
    private final NotificationCompat.Builder notificationBuilder;

    public DownloadNotificationHelper(Context context, String channelId) {
        this.context = context = context.getApplicationContext();
        this.notificationBuilder = new NotificationCompat.Builder(context, channelId);
    }

    public Notification buildProgressNotification(@DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, List<Download> downloads) {
        float totalPercentage = 0.0f;
        int downloadTaskCount = 0;
        boolean allDownloadPercentagesUnknown = true;
        boolean haveDownloadedBytes = false;
        boolean haveDownloadTasks = false;
        boolean haveRemoveTasks = false;
        for (int i = 0; i < downloads.size(); ++i) {
            Download download = downloads.get(i);
            if (download.state == 5) {
                haveRemoveTasks = true;
                continue;
            }
            if (download.state != 7 && download.state != 2) continue;
            haveDownloadTasks = true;
            float downloadPercentage = download.getPercentDownloaded();
            if (downloadPercentage != -1.0f) {
                allDownloadPercentagesUnknown = false;
                totalPercentage += downloadPercentage;
            }
            haveDownloadedBytes |= download.getBytesDownloaded() > 0L;
            ++downloadTaskCount;
        }
        int titleStringId = haveDownloadTasks ? R.string.exo_download_downloading : (haveRemoveTasks ? R.string.exo_download_removing : 0);
        int progress = 0;
        boolean indeterminate = true;
        if (haveDownloadTasks) {
            progress = (int)(totalPercentage / (float)downloadTaskCount);
            indeterminate = allDownloadPercentagesUnknown && haveDownloadedBytes;
        }
        return this.buildNotification(smallIcon, contentIntent, message, titleStringId, 100, progress, indeterminate, true, false);
    }

    public Notification buildDownloadCompletedNotification(@DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message) {
        int titleStringId = R.string.exo_download_completed;
        return this.buildEndStateNotification(smallIcon, contentIntent, message, titleStringId);
    }

    public Notification buildDownloadFailedNotification(@DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message) {
        int titleStringId = R.string.exo_download_failed;
        return this.buildEndStateNotification(smallIcon, contentIntent, message, titleStringId);
    }

    private Notification buildEndStateNotification(@DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, @StringRes int titleStringId) {
        return this.buildNotification(smallIcon, contentIntent, message, titleStringId, 0, 0, false, false, true);
    }

    private Notification buildNotification(@DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, @StringRes int titleStringId, int maxProgress, int currentProgress, boolean indeterminateProgress, boolean ongoing, boolean showWhen) {
        this.notificationBuilder.setSmallIcon(smallIcon);
        this.notificationBuilder.setContentTitle(titleStringId == 0 ? null : this.context.getResources().getString(titleStringId));
        this.notificationBuilder.setContentIntent(contentIntent);
        this.notificationBuilder.setStyle(message == null ? null : new NotificationCompat.BigTextStyle().bigText((CharSequence)message));
        this.notificationBuilder.setProgress(maxProgress, currentProgress, indeterminateProgress);
        this.notificationBuilder.setOngoing(ongoing);
        this.notificationBuilder.setShowWhen(showWhen);
        return this.notificationBuilder.build();
    }
}

