/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.embedding;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.window.extensions.embedding.EmbeddingRule;
import java.util.function.Predicate;

public class ActivityRule
extends EmbeddingRule {
    @NonNull
    private final Predicate<Activity> mActivityPredicate;
    @NonNull
    private final Predicate<Intent> mIntentPredicate;
    private final boolean mShouldAlwaysExpand;

    ActivityRule(@NonNull Predicate<Activity> activityPredicate, @NonNull Predicate<Intent> intentPredicate, boolean shouldAlwaysExpand) {
        this.mActivityPredicate = activityPredicate;
        this.mIntentPredicate = intentPredicate;
        this.mShouldAlwaysExpand = shouldAlwaysExpand;
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean matchesActivity(@NonNull Activity activity) {
        return this.mActivityPredicate.test(activity);
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean matchesIntent(@NonNull Intent intent) {
        return this.mIntentPredicate.test(intent);
    }

    public boolean shouldAlwaysExpand() {
        return this.mShouldAlwaysExpand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityRule)) {
            return false;
        }
        ActivityRule that = (ActivityRule)o;
        return this.mShouldAlwaysExpand == that.mShouldAlwaysExpand && this.mActivityPredicate.equals(that.mActivityPredicate) && this.mIntentPredicate.equals(that.mIntentPredicate);
    }

    public int hashCode() {
        int result = this.mActivityPredicate.hashCode();
        result = 31 * result + this.mIntentPredicate.hashCode();
        result = 31 * result + (this.mShouldAlwaysExpand ? 1 : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return "ActivityRule{mShouldAlwaysExpand=" + this.mShouldAlwaysExpand + '}';
    }

    public static final class Builder {
        @NonNull
        private final Predicate<Activity> mActivityPredicate;
        @NonNull
        private final Predicate<Intent> mIntentPredicate;
        private boolean mAlwaysExpand;

        public Builder(@NonNull Predicate<Activity> activityPredicate, @NonNull Predicate<Intent> intentPredicate) {
            this.mActivityPredicate = activityPredicate;
            this.mIntentPredicate = intentPredicate;
        }

        @NonNull
        public Builder setShouldAlwaysExpand(boolean alwaysExpand) {
            this.mAlwaysExpand = alwaysExpand;
            return this;
        }

        @NonNull
        public ActivityRule build() {
            return new ActivityRule(this.mActivityPredicate, this.mIntentPredicate, this.mAlwaysExpand);
        }
    }
}

