/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.embedding;

import androidx.annotation.NonNull;
import androidx.window.extensions.embedding.ActivityStack;

public class SplitInfo {
    @NonNull
    private final ActivityStack mPrimaryActivityStack;
    @NonNull
    private final ActivityStack mSecondaryActivityStack;
    private final float mSplitRatio;

    public SplitInfo(@NonNull ActivityStack primaryActivityStack, @NonNull ActivityStack secondaryActivityStack, float splitRatio) {
        this.mPrimaryActivityStack = primaryActivityStack;
        this.mSecondaryActivityStack = secondaryActivityStack;
        this.mSplitRatio = splitRatio;
    }

    @NonNull
    public ActivityStack getPrimaryActivityStack() {
        return this.mPrimaryActivityStack;
    }

    @NonNull
    public ActivityStack getSecondaryActivityStack() {
        return this.mSecondaryActivityStack;
    }

    public float getSplitRatio() {
        return this.mSplitRatio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SplitInfo)) {
            return false;
        }
        SplitInfo that = (SplitInfo)o;
        return Float.compare(that.mSplitRatio, this.mSplitRatio) == 0 && this.mPrimaryActivityStack.equals(that.mPrimaryActivityStack) && this.mSecondaryActivityStack.equals(that.mSecondaryActivityStack);
    }

    public int hashCode() {
        int result = this.mPrimaryActivityStack.hashCode();
        result = result * 31 + this.mSecondaryActivityStack.hashCode();
        result = result * 31 + (int)(this.mSplitRatio * 17.0f);
        return result;
    }

    @NonNull
    public String toString() {
        return "SplitInfo{mPrimaryActivityStack=" + this.mPrimaryActivityStack + ", mSecondaryActivityStack=" + this.mSecondaryActivityStack + ", mSplitRatio=" + this.mSplitRatio + '}';
    }
}

