/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.embedding;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.util.Pair;
import android.view.WindowMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.window.extensions.embedding.SplitRule;
import java.util.function.Predicate;

public class SplitPairRule
extends SplitRule {
    @NonNull
    private final Predicate<Pair<Activity, Activity>> mActivityPairPredicate;
    @NonNull
    private final Predicate<Pair<Activity, Intent>> mActivityIntentPredicate;
    private final int mFinishPrimaryWithSecondary;
    private final int mFinishSecondaryWithPrimary;
    private final boolean mClearTop;

    SplitPairRule(float splitRatio, int layoutDirection, int finishPrimaryWithSecondary, int finishSecondaryWithPrimary, boolean clearTop, @NonNull Predicate<Pair<Activity, Activity>> activityPairPredicate, @NonNull Predicate<Pair<Activity, Intent>> activityIntentPredicate, @NonNull Predicate<WindowMetrics> parentWindowMetricsPredicate) {
        super(parentWindowMetricsPredicate, splitRatio, layoutDirection);
        this.mActivityPairPredicate = activityPairPredicate;
        this.mActivityIntentPredicate = activityIntentPredicate;
        this.mFinishPrimaryWithSecondary = finishPrimaryWithSecondary;
        this.mFinishSecondaryWithPrimary = finishSecondaryWithPrimary;
        this.mClearTop = clearTop;
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean matchesActivityPair(@NonNull Activity primaryActivity, @NonNull Activity secondaryActivity) {
        return this.mActivityPairPredicate.test((Pair<Activity, Activity>)new Pair((Object)primaryActivity, (Object)secondaryActivity));
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean matchesActivityIntentPair(@NonNull Activity primaryActivity, @NonNull Intent secondaryActivityIntent) {
        return this.mActivityIntentPredicate.test((Pair<Activity, Intent>)new Pair((Object)primaryActivity, (Object)secondaryActivityIntent));
    }

    public int getFinishPrimaryWithSecondary() {
        return this.mFinishPrimaryWithSecondary;
    }

    public int getFinishSecondaryWithPrimary() {
        return this.mFinishSecondaryWithPrimary;
    }

    public boolean shouldClearTop() {
        return this.mClearTop;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SplitPairRule)) {
            return false;
        }
        SplitPairRule that = (SplitPairRule)o;
        return super.equals(o) && this.mActivityPairPredicate.equals(that.mActivityPairPredicate) && this.mActivityIntentPredicate.equals(that.mActivityIntentPredicate) && this.mFinishPrimaryWithSecondary == that.mFinishPrimaryWithSecondary && this.mFinishSecondaryWithPrimary == that.mFinishSecondaryWithPrimary && this.mClearTop == that.mClearTop;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mActivityPairPredicate.hashCode();
        result = 31 * result + this.mActivityIntentPredicate.hashCode();
        result = 31 * result + this.mFinishPrimaryWithSecondary;
        result = 31 * result + this.mFinishSecondaryWithPrimary;
        result = 31 * result + (this.mClearTop ? 1 : 0);
        return result;
    }

    @Override
    @NonNull
    public String toString() {
        return "SplitPairRule{mFinishPrimaryWithSecondary=" + this.mFinishPrimaryWithSecondary + ", mFinishSecondaryWithPrimary=" + this.mFinishSecondaryWithPrimary + ", mClearTop=" + this.mClearTop + '}';
    }

    public static final class Builder {
        @NonNull
        private final Predicate<Pair<Activity, Activity>> mActivityPairPredicate;
        @NonNull
        private final Predicate<Pair<Activity, Intent>> mActivityIntentPredicate;
        @NonNull
        private final Predicate<WindowMetrics> mParentWindowMetricsPredicate;
        private float mSplitRatio;
        private int mLayoutDirection;
        private boolean mClearTop;
        private int mFinishPrimaryWithSecondary;
        private int mFinishSecondaryWithPrimary;

        public Builder(@NonNull Predicate<Pair<Activity, Activity>> activityPairPredicate, @NonNull Predicate<Pair<Activity, Intent>> activityIntentPredicate, @NonNull Predicate<WindowMetrics> parentWindowMetricsPredicate) {
            this.mActivityPairPredicate = activityPairPredicate;
            this.mActivityIntentPredicate = activityIntentPredicate;
            this.mParentWindowMetricsPredicate = parentWindowMetricsPredicate;
        }

        @NonNull
        public Builder setSplitRatio(float splitRatio) {
            this.mSplitRatio = splitRatio;
            return this;
        }

        @NonNull
        public Builder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setShouldFinishPrimaryWithSecondary(boolean finishPrimaryWithSecondary) {
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setShouldFinishSecondaryWithPrimary(boolean finishSecondaryWithPrimary) {
            return this;
        }

        @NonNull
        public Builder setFinishPrimaryWithSecondary(int finishBehavior) {
            this.mFinishPrimaryWithSecondary = finishBehavior;
            return this;
        }

        @NonNull
        public Builder setFinishSecondaryWithPrimary(int finishBehavior) {
            this.mFinishSecondaryWithPrimary = finishBehavior;
            return this;
        }

        @NonNull
        public Builder setShouldClearTop(boolean shouldClearTop) {
            this.mClearTop = shouldClearTop;
            return this;
        }

        @NonNull
        public SplitPairRule build() {
            return new SplitPairRule(this.mSplitRatio, this.mLayoutDirection, this.mFinishPrimaryWithSecondary, this.mFinishSecondaryWithPrimary, this.mClearTop, this.mActivityPairPredicate, this.mActivityIntentPredicate, this.mParentWindowMetricsPredicate);
        }
    }
}

