/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.embedding;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.view.WindowMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.window.extensions.embedding.SplitRule;
import java.util.function.Predicate;

public class SplitPlaceholderRule
extends SplitRule {
    @NonNull
    private final Predicate<Activity> mActivityPredicate;
    @NonNull
    private final Predicate<Intent> mIntentPredicate;
    @NonNull
    private final Intent mPlaceholderIntent;
    private final boolean mIsSticky;
    private final int mFinishPrimaryWithPlaceholder;

    SplitPlaceholderRule(@NonNull Intent placeholderIntent, float splitRatio, int layoutDirection, boolean isSticky, int finishPrimaryWithPlaceholder, @NonNull Predicate<Activity> activityPredicate, @NonNull Predicate<Intent> intentPredicate, @NonNull Predicate<WindowMetrics> parentWindowMetricsPredicate) {
        super(parentWindowMetricsPredicate, splitRatio, layoutDirection);
        this.mIsSticky = isSticky;
        this.mFinishPrimaryWithPlaceholder = finishPrimaryWithPlaceholder;
        this.mActivityPredicate = activityPredicate;
        this.mIntentPredicate = intentPredicate;
        this.mPlaceholderIntent = placeholderIntent;
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean matchesActivity(@NonNull Activity activity) {
        return this.mActivityPredicate.test(activity);
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean matchesIntent(@NonNull Intent intent) {
        return this.mIntentPredicate.test(intent);
    }

    @NonNull
    public Intent getPlaceholderIntent() {
        return this.mPlaceholderIntent;
    }

    public boolean isSticky() {
        return this.mIsSticky;
    }

    @Deprecated
    public int getFinishPrimaryWithSecondary() {
        return this.getFinishPrimaryWithPlaceholder();
    }

    public int getFinishPrimaryWithPlaceholder() {
        return this.mFinishPrimaryWithPlaceholder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SplitPlaceholderRule)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SplitPlaceholderRule that = (SplitPlaceholderRule)o;
        if (this.mIsSticky != that.mIsSticky) {
            return false;
        }
        if (this.mFinishPrimaryWithPlaceholder != that.mFinishPrimaryWithPlaceholder) {
            return false;
        }
        if (!this.mActivityPredicate.equals(that.mActivityPredicate)) {
            return false;
        }
        if (!this.mIntentPredicate.equals(that.mIntentPredicate)) {
            return false;
        }
        return this.mPlaceholderIntent.equals(that.mPlaceholderIntent);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mActivityPredicate.hashCode();
        result = 31 * result + this.mIntentPredicate.hashCode();
        result = 31 * result + this.mPlaceholderIntent.hashCode();
        result = 31 * result + (this.mIsSticky ? 1 : 0);
        result = 31 * result + this.mFinishPrimaryWithPlaceholder;
        return result;
    }

    @Override
    @NonNull
    public String toString() {
        return "SplitPlaceholderRule{mActivityPredicate=" + this.mActivityPredicate + ", mIsSticky=" + this.mIsSticky + ", mFinishPrimaryWithPlaceholder=" + this.mFinishPrimaryWithPlaceholder + '}';
    }

    public static final class Builder {
        @NonNull
        private final Predicate<Activity> mActivityPredicate;
        @NonNull
        private final Predicate<Intent> mIntentPredicate;
        @NonNull
        private final Predicate<WindowMetrics> mParentWindowMetricsPredicate;
        @NonNull
        private final Intent mPlaceholderIntent;
        private float mSplitRatio;
        private int mLayoutDirection;
        private boolean mIsSticky = false;
        private int mFinishPrimaryWithPlaceholder = 1;

        public Builder(@NonNull Intent placeholderIntent, @NonNull Predicate<Activity> activityPredicate, @NonNull Predicate<Intent> intentPredicate, @NonNull Predicate<WindowMetrics> parentWindowMetricsPredicate) {
            this.mActivityPredicate = activityPredicate;
            this.mIntentPredicate = intentPredicate;
            this.mPlaceholderIntent = placeholderIntent;
            this.mParentWindowMetricsPredicate = parentWindowMetricsPredicate;
        }

        @NonNull
        public Builder setSplitRatio(float splitRatio) {
            this.mSplitRatio = splitRatio;
            return this;
        }

        @NonNull
        public Builder setLayoutDirection(int layoutDirection) {
            this.mLayoutDirection = layoutDirection;
            return this;
        }

        @NonNull
        public Builder setSticky(boolean sticky) {
            this.mIsSticky = sticky;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setFinishPrimaryWithSecondary(int finishBehavior) {
            if (finishBehavior == 0) {
                finishBehavior = 1;
            }
            return this.setFinishPrimaryWithPlaceholder(finishBehavior);
        }

        @NonNull
        public Builder setFinishPrimaryWithPlaceholder(int finishBehavior) {
            this.mFinishPrimaryWithPlaceholder = finishBehavior;
            return this;
        }

        @NonNull
        public SplitPlaceholderRule build() {
            return new SplitPlaceholderRule(this.mPlaceholderIntent, this.mSplitRatio, this.mLayoutDirection, this.mIsSticky, this.mFinishPrimaryWithPlaceholder, this.mActivityPredicate, this.mIntentPredicate, this.mParentWindowMetricsPredicate);
        }
    }
}

