/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.embedding;

import android.annotation.SuppressLint;
import android.view.WindowMetrics;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.window.extensions.embedding.EmbeddingRule;
import java.util.function.Predicate;

public abstract class SplitRule
extends EmbeddingRule {
    @NonNull
    private final Predicate<WindowMetrics> mParentWindowMetricsPredicate;
    private final float mSplitRatio;
    private final int mLayoutDirection;
    public static final int FINISH_NEVER = 0;
    public static final int FINISH_ALWAYS = 1;
    public static final int FINISH_ADJACENT = 2;

    SplitRule(@NonNull Predicate<WindowMetrics> parentWindowMetricsPredicate, float splitRatio, int layoutDirection) {
        this.mParentWindowMetricsPredicate = parentWindowMetricsPredicate;
        this.mSplitRatio = splitRatio;
        this.mLayoutDirection = layoutDirection;
    }

    @SuppressLint(value={"ClassVerificationFailure"})
    @RequiresApi(api=24)
    public boolean checkParentMetrics(@NonNull WindowMetrics parentMetrics) {
        return this.mParentWindowMetricsPredicate.test(parentMetrics);
    }

    public float getSplitRatio() {
        return this.mSplitRatio;
    }

    public int getLayoutDirection() {
        return this.mLayoutDirection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SplitRule)) {
            return false;
        }
        SplitRule that = (SplitRule)o;
        return Float.compare(that.mSplitRatio, this.mSplitRatio) == 0 && this.mParentWindowMetricsPredicate.equals(that.mParentWindowMetricsPredicate) && this.mLayoutDirection == that.mLayoutDirection;
    }

    public int hashCode() {
        int result = (int)(this.mSplitRatio * 17.0f);
        result = 31 * result + this.mParentWindowMetricsPredicate.hashCode();
        result = 31 * result + this.mLayoutDirection;
        return result;
    }

    @NonNull
    public String toString() {
        return "SplitRule{mSplitRatio=" + this.mSplitRatio + ", mLayoutDirection=" + this.mLayoutDirection + '}';
    }
}

