/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.layout;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.window.extensions.layout.DisplayFeature;

public class FoldingFeature
implements DisplayFeature {
    public static final int TYPE_FOLD = 1;
    public static final int TYPE_HINGE = 2;
    public static final int STATE_FLAT = 1;
    public static final int STATE_HALF_OPENED = 2;
    @NonNull
    private final Rect mBounds;
    private final int mType;
    private final int mState;

    public FoldingFeature(@NonNull Rect bounds, int type, int state) {
        FoldingFeature.validateFeatureBounds(bounds);
        this.mBounds = new Rect(bounds);
        this.mType = type;
        this.mState = state;
    }

    @Override
    @NonNull
    public Rect getBounds() {
        return new Rect(this.mBounds);
    }

    public int getType() {
        return this.mType;
    }

    public int getState() {
        return this.mState;
    }

    private static void validateFeatureBounds(@NonNull Rect bounds) {
        if (bounds.width() == 0 && bounds.height() == 0) {
            throw new IllegalArgumentException("Bounds must be non zero");
        }
        if (bounds.left != 0 && bounds.top != 0) {
            throw new IllegalArgumentException("Bounding rectangle must start at the top or left window edge for folding features");
        }
    }

    @NonNull
    private static String typeToString(int type) {
        switch (type) {
            case 1: {
                return "FOLD";
            }
            case 2: {
                return "HINGE";
            }
        }
        return "Unknown feature type (" + type + ")";
    }

    @NonNull
    private static String stateToString(int state) {
        switch (state) {
            case 1: {
                return "FLAT";
            }
            case 2: {
                return "HALF_OPENED";
            }
        }
        return "Unknown feature state (" + state + ")";
    }

    @NonNull
    public String toString() {
        return "ExtensionDisplayFoldFeature { " + this.mBounds + ", type=" + FoldingFeature.typeToString(this.getType()) + ", state=" + FoldingFeature.stateToString(this.mState) + " }";
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FoldingFeature)) {
            return false;
        }
        FoldingFeature other = (FoldingFeature)obj;
        if (this.mType != other.mType) {
            return false;
        }
        if (this.mState != other.mState) {
            return false;
        }
        return this.mBounds.equals((Object)other.mBounds);
    }

    private static int hashBounds(Rect bounds) {
        int result = bounds.left;
        result = 31 * result + bounds.top;
        result = 31 * result + bounds.right;
        result = 31 * result + bounds.bottom;
        return result;
    }

    public int hashCode() {
        int result = FoldingFeature.hashBounds(this.mBounds);
        result = 31 * result + this.mType;
        result = 31 * result + this.mState;
        return result;
    }
}

