/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.extensions.layout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.window.extensions.layout.DisplayFeature;
import java.util.Collections;
import java.util.List;

public class WindowLayoutInfo {
    @NonNull
    private List<DisplayFeature> mDisplayFeatures;

    public WindowLayoutInfo(@NonNull List<DisplayFeature> displayFeatures) {
        this.mDisplayFeatures = Collections.unmodifiableList(displayFeatures);
    }

    @NonNull
    public List<DisplayFeature> getDisplayFeatures() {
        return this.mDisplayFeatures;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExtensionWindowLayoutInfo { ExtensionDisplayFeatures[ ");
        for (int i = 0; i < this.mDisplayFeatures.size(); ++i) {
            sb.append(this.mDisplayFeatures.get(i));
            if (i >= this.mDisplayFeatures.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" ] }");
        return sb.toString();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WindowLayoutInfo)) {
            return false;
        }
        WindowLayoutInfo other = (WindowLayoutInfo)obj;
        if (this.mDisplayFeatures == null) {
            return other.mDisplayFeatures == null;
        }
        return this.mDisplayFeatures.equals(other.mDisplayFeatures);
    }

    public int hashCode() {
        return this.mDisplayFeatures != null ? this.mDisplayFeatures.size() : 0;
    }
}

