/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzai;
import com.google.android.gms.internal.firebase-auth-api.zzap;
import com.google.android.gms.internal.firebase-auth-api.zzat;
import com.google.android.gms.internal.firebase-auth-api.zzau;
import com.google.android.gms.internal.firebase-auth-api.zzav;
import com.google.android.gms.internal.firebase-auth-api.zzdk;
import com.google.android.gms.internal.firebase-auth-api.zzdn;
import com.google.android.gms.internal.firebase-auth-api.zzdo;
import com.google.android.gms.internal.firebase-auth-api.zzdp;
import com.google.android.gms.internal.firebase-auth-api.zzht;
import com.google.android.gms.internal.firebase-auth-api.zzkr;
import com.google.android.gms.internal.firebase-auth-api.zzzw;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.concurrent.GuardedBy;
import javax.crypto.KeyGenerator;

public final class zzdj {
    private zzav zza = null;
    private String zzb = null;
    private zzag zzc = null;
    private zzap zzd = null;
    @GuardedBy(value="this")
    private zzau zze;
    private zzdo zzf = null;

    public final zzdj zza(Context context, String string, String string2) throws IOException {
        if (context == null) {
            Object object = new IllegalArgumentException("need an Android context");
            throw object;
        }
        string = "GenericIdpKeyset";
        Object object = new zzdo(context, string, string2);
        ((zzdj)object).zzf = object;
        ((zzdj)object).zza = object = new zzdp(context, string, string2);
        return object;
    }

    public final zzdj zzb(String string) {
        if (!string.startsWith("android-keystore://")) {
            Object object = new IllegalArgumentException("key URI must start with android-keystore://");
            throw object;
        }
        ((zzdj)object).zzb = string;
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public final zzdj zzc(zzht object) {
        int n;
        String string = ((zzht)object).zza();
        byte[] byArray = ((zzht)object).zzb().zzp();
        object = ((zzht)object).zzc();
        switch (((Enum)object).ordinal()) {
            case 1: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
            default: {
                Object object2 = new IllegalArgumentException("Unknown output prefix type");
                throw object2;
            }
            case 2: {
                n = 2;
            }
        }
        ((zzdj)object2).zzd = zzap.zzb(string, byArray, n);
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized zzdk zzd() throws GeneralSecurityException, IOException {
        Object object;
        if (((zzdj)object2).zzb != null) {
            ((zzdj)object2).zzc = ((zzdj)object2).zzh();
        }
        try {
            object = ((zzdj)object2).zzi();
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.w((String)zzdk.zzb(), (String)"keyset not found, will generate a new one", (Throwable)fileNotFoundException);
            if (((zzdj)object2).zzd == null) {
                Object object2 = new GeneralSecurityException("cannot read or generate keyset");
                throw object2;
            }
            object = zzau.zzb();
            ((zzau)object).zzd(((zzdj)object2).zzd);
            ((zzau)object).zzf(((zzau)object).zzc().zzc().zza(0).zza());
            if (((zzdj)object2).zzc != null) {
                ((zzau)object).zzc().zzd(((zzdj)object2).zza, ((zzdj)object2).zzc);
            }
            zzai.zza(((zzau)object).zzc(), ((zzdj)object2).zza);
        }
        ((zzdj)object2).zze = object;
        return new zzdk((zzdj)object2, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final zzag zzh() throws GeneralSecurityException {
        Object[] objectArray;
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)zzdk.zzb(), (String)"Android Keystore requires at least Android M");
            return null;
        }
        Object[] objectArray2 = new zzdn();
        boolean bl = objectArray2.zzc(((zzdj)object).zzb);
        if (!bl) {
            objectArray = ((zzdj)object).zzb;
            zzdn zzdn2 = new zzdn();
            boolean bl2 = zzdn2.zzc((String)objectArray);
            if (bl2) {
                objectArray2 = new Object[]{objectArray};
                Object object = new IllegalArgumentException(String.format("cannot generate a new key %s because it already exists; please delete it with deleteKey() and try again", objectArray2));
                throw object;
            }
            Object object = "android-keystore://";
            objectArray = zzkr.zzc((String)object, (String)objectArray);
            object = "AES";
            String[] stringArray = "AndroidKeyStore";
            object = KeyGenerator.getInstance((String)object, (String)stringArray);
            stringArray = new KeyGenParameterSpec.Builder((String)objectArray, 3);
            objectArray = stringArray.setKeySize(256);
            stringArray = new String[]{"GCM"};
            objectArray = objectArray.setBlockModes(stringArray);
            stringArray = new String[]{"NoPadding"};
            ((KeyGenerator)object).init((AlgorithmParameterSpec)objectArray.setEncryptionPaddings(stringArray).build());
            ((KeyGenerator)object).generateKey();
        }
        return objectArray2.zzb(((zzdj)object).zzb);
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zzdk.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            if (bl) {
                objectArray = new Object[]{((zzdj)object).zzb};
                KeyStoreException keyStoreException = new KeyStoreException(String.format("the master key %s exists but is unusable", objectArray), exception);
                throw keyStoreException;
            }
            Log.w((String)zzdk.zzb(), (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final zzau zzi() throws GeneralSecurityException, IOException {
        zzag zzag2 = this.zzc;
        if (zzag2 == null) return zzau.zza(zzai.zzb(this.zzf));
        try {
            zzdo zzdo2 = this.zzf;
            return zzau.zza(zzat.zzi(zzdo2, zzag2));
        }
        catch (zzzw | GeneralSecurityException exception) {
            Log.w((String)zzdk.zzb(), (String)"cannot decrypt keyset: ", (Throwable)exception);
            return zzau.zza(zzai.zzb(this.zzf));
        }
    }

    static /* synthetic */ zzav zze(zzdj zzdj2) {
        return zzdj2.zza;
    }

    static /* synthetic */ zzag zzf(zzdj zzdj2) {
        return zzdj2.zzc;
    }

    static /* synthetic */ zzau zzg(zzdj zzdj2) {
        return zzdj2.zze;
    }
}

