/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzjg;
import com.google.android.gms.internal.firebase-auth-api.zzjh;
import com.google.android.gms.internal.firebase-auth-api.zzkr;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzji
implements zzag {
    private static final ThreadLocal<Cipher> zza;
    private static final ThreadLocal<Cipher> zzb;
    private final byte[] zzc;
    private final byte[] zzd;
    private final SecretKeySpec zze;
    private final int zzf;

    public zzji(byte[] object, int n) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        if (n != 12 && n != 16) {
            Object object2 = new IllegalArgumentException("IV size should be either 12 or 16 bytes");
            throw object2;
        }
        ((zzji)object2).zzf = n;
        zzkr.zza(((byte[])object).length);
        ((zzji)object2).zze = secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        object = zza.get();
        ((Cipher)object).init(1, ((zzji)object2).zze);
        ((zzji)object2).zzc = zzji.zzd(((Cipher)object).doFinal(new byte[16]));
        ((zzji)object2).zzd = zzji.zzd(((zzji)object2).zzc);
    }

    private static byte[] zzc(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        byte[] byArray3 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] zzd(byte[] byArray) {
        byte[] byArray2 = new byte[16];
        int n = 0;
        while (n < 15) {
            byte by = byArray[n];
            int n2 = n + 1;
            byArray2[n] = (byte)((by + by ^ (byArray[n2] & 0xFF) >>> 7) & 0xFF);
            n = n2;
        }
        n = byArray[15];
        n += n;
        int n3 = (byArray[0] & 0x80) == 0 ? 0 : 135;
        byArray2[15] = (byte)(n ^ n3);
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte[] zze(Cipher cipher, int n, byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        Object object;
        byte[] byArray2 = new byte[16];
        byArray2[15] = (byte)n;
        if (n3 == 0) {
            return cipher.doFinal(zzji.zzc(byArray2, ((zzji)object).zzc));
        }
        byte[] byArray3 = cipher.doFinal(byArray2);
        int n4 = 0;
        while (n3 - n4 > 16) {
            for (int i = 0; i < 16; ++i) {
                byArray3[i] = (byte)(byArray3[i] ^ byArray[n2 + n4 + i]);
            }
            byArray3 = cipher.doFinal(byArray3);
            n4 += 16;
        }
        if ((byArray = Arrays.copyOfRange(byArray, n2 + n4, n2 + n3)).length == 16) {
            object = zzji.zzc(byArray, ((zzji)object).zzc);
            return cipher.doFinal(zzji.zzc(byArray3, (byte[])object));
        }
        byte[] byArray4 = Arrays.copyOf(((zzji)object).zzd, 16);
        for (int i = 0; i < (n3 = byArray.length); ++i) {
            byArray4[i] = (byte)(byArray4[i] ^ byArray[i]);
        }
        byArray4[n3] = (byte)(byArray4[n3] ^ 0x80);
        object = byArray4;
        return cipher.doFinal(zzji.zzc(byArray3, (byte[])object));
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        throw null;
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        Object object;
        int n = byArray.length;
        int n2 = n - ((zzji)object).zzf + -16;
        if (n2 < 0) {
            object = new GeneralSecurityException("ciphertext too short");
            throw object;
        }
        Object object2 = zza.get();
        ((Cipher)object2).init(1, ((zzji)object).zze);
        byte[] byArray3 = super.zze((Cipher)object2, 0, byArray, 0, ((zzji)object).zzf);
        byte[] byArray4 = super.zze((Cipher)object2, 1, byArray2, 0, byArray2.length);
        object2 = super.zze((Cipher)object2, 2, byArray, ((zzji)object).zzf, n2);
        int n3 = n + -16;
        int n4 = 0;
        for (n = 0; n < 16; ++n) {
            n4 = (byte)(n4 | byArray[n3 + n] ^ byArray4[n] ^ byArray3[n] ^ object2[n]);
        }
        if (n4 != 0) {
            object = new AEADBadTagException("tag mismatch");
            throw object;
        }
        Cipher cipher = zzb.get();
        SecretKeySpec secretKeySpec = ((zzji)object).zze;
        object2 = new IvParameterSpec(byArray3);
        cipher.init(1, (Key)secretKeySpec, (AlgorithmParameterSpec)object2);
        return cipher.doFinal(byArray, ((zzji)object).zzf, n2);
    }

    static {
        ThreadLocal threadLocal;
        zza = threadLocal = new zzjg();
        zzb = threadLocal = new zzjh();
    }
}

