/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzea;
import com.google.android.gms.internal.firebase-auth-api.zzkl;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;

public final class zzkm
implements zzea {
    private final ThreadLocal<Mac> zza;
    private final String zzb;
    private final Key zzc;
    private final int zzd;

    /*
     * Enabled aggressive block sorting
     */
    public zzkm(String string, Key key) throws GeneralSecurityException {
        block15: {
            Object object;
            block14: {
                int n;
                block13: {
                    zzkl zzkl2;
                    ((zzkm)object).zza = zzkl2 = new zzkl((zzkm)object);
                    ((zzkm)object).zzb = string;
                    ((zzkm)object).zzc = key;
                    if (key.getEncoded().length < 16) {
                        object = new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
                        throw object;
                    }
                    switch (string.hashCode()) {
                        case 392317873: {
                            if (!string.equals("HMACSHA512")) break;
                            n = 3;
                            break block13;
                        }
                        case 392316170: {
                            if (!string.equals("HMACSHA384")) break;
                            n = 2;
                            break block13;
                        }
                        case 392315118: {
                            if (!string.equals("HMACSHA256")) break;
                            n = 1;
                            break block13;
                        }
                        case -1823053428: {
                            if (!string.equals("HMACSHA1")) break;
                            n = 0;
                            break block13;
                        }
                    }
                    n = -1;
                }
                switch (n) {
                    default: {
                        object = "unknown Hmac algorithm: ";
                        if (string.length() == 0) break block14;
                        object = ((String)object).concat(string);
                        break block15;
                    }
                    case 3: {
                        ((zzkm)object).zzd = 64;
                        break;
                    }
                    case 2: {
                        ((zzkm)object).zzd = 48;
                        break;
                    }
                    case 1: {
                        ((zzkm)object).zzd = 32;
                        break;
                    }
                    case 0: {
                        ((zzkm)object).zzd = 20;
                        break;
                    }
                }
                ((zzkm)object).zza.get();
                return;
            }
            string = new String((String)object);
            object = string;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException((String)object);
        throw noSuchAlgorithmException;
    }

    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        if (n > ((zzkm)object).zzd) {
            Object object = new InvalidAlgorithmParameterException("tag size too big");
            throw object;
        }
        ((zzkm)object).zza.get().update(byArray);
        return Arrays.copyOf(((zzkm)object).zza.get().doFinal(), n);
    }

    static /* synthetic */ String zzb(zzkm zzkm2) {
        return zzkm2.zzb;
    }

    static /* synthetic */ Key zzc(zzkm zzkm2) {
        return zzkm2.zzc;
    }
}

