/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.firebase-auth-api.zzlb;
import com.google.android.gms.internal.firebase-auth-api.zztz;
import com.google.android.gms.internal.firebase-auth-api.zzwh;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public final class zzwg
extends AbstractSafeParcelable
implements zztz<zzwg> {
    private static final String zza;
    public static final Parcelable.Creator<zzwg> CREATOR;
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzd;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zze;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzf;

    public zzwg() {
        this.zzf = System.currentTimeMillis();
    }

    public zzwg(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzwg(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzb = string;
        this.zzc = string2;
        this.zzd = l;
        this.zze = string3;
        this.zzf = l2;
    }

    public final boolean zzb() {
        Long l = ((zzwg)((Object)l3)).zzf;
        long l2 = l;
        Long l3 = ((zzwg)((Object)l3)).zzd;
        long l4 = l3;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l2 + l4 * 1000L;
    }

    public final void zzc(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
    }

    public final String zzd() {
        return this.zzb;
    }

    public final String zze() {
        return this.zzc;
    }

    public final long zzf() {
        Long l = ((zzwg)((Object)l)).zzd;
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Nullable
    public final String zzg() {
        return this.zze;
    }

    public final long zzh() {
        return this.zzf;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        n = SafeParcelWriter.beginObjectHeader((Parcel)parcel);
        SafeParcelWriter.writeString((Parcel)parcel, (int)2, (String)this.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)3, (String)this.zzc, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)4, (Long)this.zzf(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel, (int)5, (String)this.zze, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel, (int)6, (Long)this.zzf, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel, (int)n);
    }

    public final String zzi() {
        Object object = new JSONObject();
        try {
            object.put("refresh_token", (Object)((zzwg)((Object)string)).zzb);
            object.put("access_token", (Object)((zzwg)((Object)string)).zzc);
            object.put("expires_in", (Object)((zzwg)((Object)string)).zzd);
            object.put("token_type", (Object)((zzwg)((Object)string)).zze);
            object.put("issued_at", (Object)((zzwg)((Object)string)).zzf);
            String string = object.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to convert GetTokenResponse to JSON");
            object = new zzlb(jSONException);
            throw object;
        }
        return string;
    }

    public static zzwg zzj(String object) {
        try {
            JSONObject jSONObject = new JSONObject((String)object);
            object = new zzwg();
            ((zzwg)object).zzb = jSONObject.optString("refresh_token", null);
            ((zzwg)object).zzc = jSONObject.optString("access_token", null);
            ((zzwg)object).zzd = jSONObject.optLong("expires_in");
            ((zzwg)object).zze = jSONObject.optString("token_type", null);
            ((zzwg)object).zzf = jSONObject.optLong("issued_at");
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to read GetTokenResponse from JSONObject");
            zzlb zzlb2 = new zzlb(jSONException);
            throw zzlb2;
        }
        return object;
    }

    static {
        zzwh zzwh2;
        zza = zzwg.class.getSimpleName();
        CREATOR = zzwh2 = new zzwh();
    }
}

