/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.auth.zzc;
import java.util.Map;
import java.util.Set;

public class ActionCodeUrl {
    private final String zza;
    private final String zzb;
    private final String zzc;
    @Nullable
    private final String zzd;
    @Nullable
    private final String zze;
    @Nullable
    private final String zzf;
    private static final Map<String, Integer> zzg;

    private ActionCodeUrl(String objectArray) {
        ((ActionCodeUrl)object).zza = ActionCodeUrl.zzb((String)objectArray, "apiKey");
        ((ActionCodeUrl)object).zzb = ActionCodeUrl.zzb((String)objectArray, "oobCode");
        ((ActionCodeUrl)object).zzc = ActionCodeUrl.zzb((String)objectArray, "mode");
        if (((ActionCodeUrl)object).zza == null || ((ActionCodeUrl)object).zzb == null || ((ActionCodeUrl)object).zzc == null) {
            objectArray = new Object[]{"apiKey", "oobCode", "mode"};
            Object object = new IllegalArgumentException(String.format("%s, %s and %s are required in a valid action code URL", objectArray));
            throw object;
        }
        ((ActionCodeUrl)object).zzd = ActionCodeUrl.zzb((String)objectArray, "continueUrl");
        ((ActionCodeUrl)object).zze = ActionCodeUrl.zzb((String)objectArray, "languageCode");
        ((ActionCodeUrl)object).zzf = ActionCodeUrl.zzb((String)objectArray, "tenantId");
    }

    @Nullable
    public static ActionCodeUrl parseLink(@NonNull String string) {
        Preconditions.checkNotEmpty((String)string);
        try {
            ActionCodeUrl actionCodeUrl = new ActionCodeUrl(string);
            return actionCodeUrl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @NonNull
    public String getApiKey() {
        return this.zza;
    }

    public int getOperation() {
        if (zzg.containsKey(this.zzc)) {
            return zzg.get(this.zzc);
        }
        return 3;
    }

    @NonNull
    public String getCode() {
        return this.zzb;
    }

    @Nullable
    public String getContinueUrl() {
        return this.zzd;
    }

    @Nullable
    public String getLanguageCode() {
        return this.zze;
    }

    static {
        zzc zzc2;
        zzg = zzc2 = new zzc();
    }

    @Nullable
    public final String zza() {
        return this.zzf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String zzb(String string, String string2) {
        Set set;
        block6: {
            string = Uri.parse((String)string);
            try {
                set = string.getQueryParameterNames();
                boolean bl = set.contains(string2);
                if (!bl) break block6;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                return null;
            }
            return string.getQueryParameter(string2);
        }
        boolean bl = set.contains("link");
        if (!bl) return null;
        return Uri.parse((String)string.getQueryParameter("link")).getQueryParameter(string2);
    }
}

