class Conv2d(Module):
  __parameters__ = []
  training : bool
  in_channels : int
  out_channels : int
  kernel_size : Tuple[int, int]
  stride : Tuple[int, int]
  padding : Tuple[int, int]
  dilation : Tuple[int, int]
  transposed : bool
  output_padding : Tuple[int, int]
  groups : int
  padding_mode : str
  _packed_params : Tensor
  scale : float
  zero_point : int
  def __getstate__(self: __torch__.torch.nn.quantized.modules.conv.___torch_mangle_0.Conv2d) -> Tuple[int, int, Tuple[int, int], Tuple[int, int], Tuple[int, int], Tuple[int, int], bool, Tuple[int, int], int, str, Tensor, Optional[Tensor], float, int, bool]:
    w, b, = (self)._weight_bias()
    _0 = (self.in_channels, self.out_channels, self.kernel_size, self.stride, self.padding, self.dilation, self.transposed, self.output_padding, self.groups, self.padding_mode, w, b, self.scale, self.zero_point, self.training)
    return _0
  def __setstate__(self: __torch__.torch.nn.quantized.modules.conv.___torch_mangle_0.Conv2d,
    state: Tuple[int, int, Tuple[int, int], Tuple[int, int], Tuple[int, int], Tuple[int, int], bool, Tuple[int, int], int, str, Tensor, Optional[Tensor], float, int, bool]) -> None:
    self.in_channels = (state)[0]
    self.out_channels = (state)[1]
    self.kernel_size = (state)[2]
    self.stride = (state)[3]
    self.padding = (state)[4]
    self.dilation = (state)[5]
    self.transposed = (state)[6]
    self.output_padding = (state)[7]
    self.groups = (state)[8]
    self.padding_mode = (state)[9]
    _1 = (self).set_weight_bias((state)[10], (state)[11], )
    self.scale = (state)[12]
    self.zero_point = (state)[13]
    self.training = (state)[14]
    return None
  def _weight_bias(self: __torch__.torch.nn.quantized.modules.conv.___torch_mangle_0.Conv2d) -> Tuple[Tensor, Optional[Tensor]]:
    _2, _3 = ops.quantized.conv2d_unpack(self._packed_params)
    return (_2, _3)
  def set_weight_bias(self: __torch__.torch.nn.quantized.modules.conv.___torch_mangle_0.Conv2d,
    w: Tensor,
    b: Optional[Tensor]) -> None:
    _4 = self.stride
    _5 = self.padding
    _6 = self.dilation
    _7 = self.groups
    _8, _9, = _4
    _10 = [_8, _9]
    _11, _12, = _5
    _13 = [_11, _12]
    _14, _15, = _6
    _16 = ops.quantized.conv2d_prepack(w, b, _10, _13, [_14, _15], _7)
    self._packed_params = _16
    return None
  def forward(self: __torch__.torch.nn.quantized.modules.conv.___torch_mangle_0.Conv2d,
    input: Tensor) -> Tensor:
    _17 = ops.quantized.conv2d(input, self._packed_params, [1, 1], [0, 0], [1, 1], 1, 1., 0)
    return _17
