class ConvReLU2d(Module):
  __parameters__ = []
  training : bool
  in_channels : int
  out_channels : int
  kernel_size : Tuple[int, int]
  stride : Tuple[int, int]
  padding : Tuple[int, int]
  dilation : Tuple[int, int]
  transposed : bool
  output_padding : Tuple[int, int]
  groups : int
  padding_mode : str
  _packed_params : Tensor
  scale : float
  zero_point : int
  def forward(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU2d,
    input: Tensor) -> Tensor:
    _0 = torch.ne(torch.len(torch.size(input)), 4)
    if _0:
      ops.prim.RaiseException("Exception")
    else:
      pass
    _1 = self._packed_params
    _2 = self.stride
    _3 = self.padding
    _4 = self.dilation
    _5 = self.groups
    _6 = self.scale
    _7 = self.zero_point
    _8, _9, = _2
    _10 = [_8, _9]
    _11, _12, = _3
    _13 = [_11, _12]
    _14, _15, = _4
    _16 = ops.quantized.conv2d_relu(input, _1, _10, _13, [_14, _15], _5, _6, _7)
    return _16
  def __getstate__(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU2d) -> Tuple[int, int, Tuple[int, int], Tuple[int, int], Tuple[int, int], Tuple[int, int], bool, Tuple[int, int], int, str, Tensor, Optional[Tensor], float, int, bool]:
    w, b, = (self)._weight_bias()
    _17 = (self.in_channels, self.out_channels, self.kernel_size, self.stride, self.padding, self.dilation, self.transposed, self.output_padding, self.groups, self.padding_mode, w, b, self.scale, self.zero_point, self.training)
    return _17
  def __setstate__(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU2d,
    state: Tuple[int, int, Tuple[int, int], Tuple[int, int], Tuple[int, int], Tuple[int, int], bool, Tuple[int, int], int, str, Tensor, Optional[Tensor], float, int, bool]) -> None:
    self.in_channels = (state)[0]
    self.out_channels = (state)[1]
    self.kernel_size = (state)[2]
    self.stride = (state)[3]
    self.padding = (state)[4]
    self.dilation = (state)[5]
    self.transposed = (state)[6]
    self.output_padding = (state)[7]
    self.groups = (state)[8]
    self.padding_mode = (state)[9]
    _18 = (self).set_weight_bias((state)[10], (state)[11], )
    self.scale = (state)[12]
    self.zero_point = (state)[13]
    self.training = (state)[14]
    return None
  def _weight_bias(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU2d) -> Tuple[Tensor, Optional[Tensor]]:
    _19, _20 = ops.quantized.conv2d_unpack(self._packed_params)
    return (_19, _20)
  def set_weight_bias(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU2d,
    w: Tensor,
    b: Optional[Tensor]) -> None:
    _21 = self.stride
    _22 = self.padding
    _23 = self.dilation
    _24 = self.groups
    _25, _26, = _21
    _27 = [_25, _26]
    _28, _29, = _22
    _30 = [_28, _29]
    _31, _32, = _23
    _33 = ops.quantized.conv2d_prepack(w, b, _27, _30, [_31, _32], _24)
    self._packed_params = _33
    return None
