class ConvReLU3d(Module):
  __parameters__ = []
  training : bool
  in_channels : int
  out_channels : int
  kernel_size : Tuple[int, int, int]
  stride : Tuple[int, int, int]
  padding : Tuple[int, int, int]
  dilation : Tuple[int, int, int]
  transposed : bool
  output_padding : Tuple[int, int, int]
  groups : int
  padding_mode : str
  _packed_params : Tensor
  scale : float
  zero_point : int
  def forward(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU3d,
    input: Tensor) -> Tensor:
    _0 = torch.ne(torch.len(torch.size(input)), 5)
    if _0:
      ops.prim.RaiseException("Exception")
    else:
      pass
    _1 = self._packed_params
    _2 = self.stride
    _3 = self.padding
    _4 = self.dilation
    _5 = self.groups
    _6 = self.scale
    _7 = self.zero_point
    _8, _9, _10, = _2
    _11 = [_8, _9, _10]
    _12, _13, _14, = _3
    _15 = [_12, _13, _14]
    _16, _17, _18, = _4
    _19 = ops.quantized.conv3d_relu(input, _1, _11, _15, [_16, _17, _18], _5, _6, _7)
    return _19
  def __getstate__(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU3d) -> Tuple[int, int, Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], bool, Tuple[int, int, int], int, str, Tensor, Optional[Tensor], float, int, bool]:
    w, b, = (self)._weight_bias()
    _20 = (self.in_channels, self.out_channels, self.kernel_size, self.stride, self.padding, self.dilation, self.transposed, self.output_padding, self.groups, self.padding_mode, w, b, self.scale, self.zero_point, self.training)
    return _20
  def __setstate__(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU3d,
    state: Tuple[int, int, Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], bool, Tuple[int, int, int], int, str, Tensor, Optional[Tensor], float, int, bool]) -> None:
    self.in_channels = (state)[0]
    self.out_channels = (state)[1]
    self.kernel_size = (state)[2]
    self.stride = (state)[3]
    self.padding = (state)[4]
    self.dilation = (state)[5]
    self.transposed = (state)[6]
    self.output_padding = (state)[7]
    self.groups = (state)[8]
    self.padding_mode = (state)[9]
    _21 = (self).set_weight_bias((state)[10], (state)[11], )
    self.scale = (state)[12]
    self.zero_point = (state)[13]
    self.training = (state)[14]
    return None
  def _weight_bias(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU3d) -> Tuple[Tensor, Optional[Tensor]]:
    _22, _23 = ops.quantized.conv3d_unpack(self._packed_params)
    return (_22, _23)
  def set_weight_bias(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.ConvReLU3d,
    w: Tensor,
    b: Optional[Tensor]) -> None:
    _24 = self.stride
    _25 = self.padding
    _26 = self.dilation
    _27 = self.groups
    _28, _29, _30, = _24
    _31 = [_28, _29, _30]
    _32, _33, _34, = _25
    _35 = [_32, _33, _34]
    _36, _37, _38, = _26
    _39 = ops.quantized.conv3d_prepack(w, b, _31, _35, [_36, _37, _38], _27)
    self._packed_params = _39
    return None
