class ConvReLU3d(Module):
  __parameters__ = []
  training : bool
  in_channels : int
  out_channels : int
  kernel_size : Tuple[int, int, int]
  stride : Tuple[int, int, int]
  padding : Tuple[int, int, int]
  dilation : Tuple[int, int, int]
  transposed : bool
  output_padding : Tuple[int, int, int]
  groups : int
  padding_mode : str
  _packed_params : Tensor
  scale : float
  zero_point : int
  def __getstate__(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.___torch_mangle_6.ConvReLU3d) -> Tuple[int, int, Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], bool, Tuple[int, int, int], int, str, Tensor, Optional[Tensor], float, int, bool]:
    w, b, = (self)._weight_bias()
    _0 = (self.in_channels, self.out_channels, self.kernel_size, self.stride, self.padding, self.dilation, self.transposed, self.output_padding, self.groups, self.padding_mode, w, b, self.scale, self.zero_point, self.training)
    return _0
  def __setstate__(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.___torch_mangle_6.ConvReLU3d,
    state: Tuple[int, int, Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], Tuple[int, int, int], bool, Tuple[int, int, int], int, str, Tensor, Optional[Tensor], float, int, bool]) -> None:
    self.in_channels = (state)[0]
    self.out_channels = (state)[1]
    self.kernel_size = (state)[2]
    self.stride = (state)[3]
    self.padding = (state)[4]
    self.dilation = (state)[5]
    self.transposed = (state)[6]
    self.output_padding = (state)[7]
    self.groups = (state)[8]
    self.padding_mode = (state)[9]
    _1 = (self).set_weight_bias((state)[10], (state)[11], )
    self.scale = (state)[12]
    self.zero_point = (state)[13]
    self.training = (state)[14]
    return None
  def _weight_bias(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.___torch_mangle_6.ConvReLU3d) -> Tuple[Tensor, Optional[Tensor]]:
    _2, _3 = ops.quantized.conv3d_unpack(self._packed_params)
    return (_2, _3)
  def set_weight_bias(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.___torch_mangle_6.ConvReLU3d,
    w: Tensor,
    b: Optional[Tensor]) -> None:
    _4 = self.stride
    _5 = self.padding
    _6 = self.dilation
    _7 = self.groups
    _8, _9, _10, = _4
    _11 = [_8, _9, _10]
    _12, _13, _14, = _5
    _15 = [_12, _13, _14]
    _16, _17, _18, = _6
    _19 = ops.quantized.conv3d_prepack(w, b, _11, _15, [_16, _17, _18], _7)
    self._packed_params = _19
    return None
  def forward(self: __torch__.torch.nn.intrinsic.quantized.modules.conv_relu.___torch_mangle_6.ConvReLU3d,
    input: Tensor) -> Tensor:
    _20 = ops.quantized.conv3d_relu(input, self._packed_params, [1, 1, 1], [0, 0, 0], [1, 1, 1], 1, 1., 0)
    return _20
