class Linear(Module):
  __parameters__ = []
  training : bool
  in_features : int
  out_features : int
  scale : float
  zero_point : int
  _packed_params : __torch__.torch.nn.quantized.modules.linear.LinearPackedParams
  def forward(self: __torch__.torch.nn.quantized.modules.linear.Linear,
    x: Tensor) -> Tensor:
    _0 = ops.quantized.linear(x, self._packed_params._packed_params, self.scale, self.zero_point)
    return _0
class LinearPackedParams(Module):
  __parameters__ = []
  training : bool
  dtype : int
  _packed_params : Tensor
  def forward(self: __torch__.torch.nn.quantized.modules.linear.LinearPackedParams,
    x: Tensor) -> Tensor:
    return x
  def __getstate__(self: __torch__.torch.nn.quantized.modules.linear.LinearPackedParams) -> Tuple[Tensor, Optional[Tensor], bool, int]:
    qweight, bias, = (self)._weight_bias()
    _1 = (qweight, bias, self.training, self.dtype)
    return _1
  def __setstate__(self: __torch__.torch.nn.quantized.modules.linear.LinearPackedParams,
    state: Tuple[Tensor, Optional[Tensor], bool, int]) -> None:
    self.dtype = (state)[3]
    _2 = (self).set_weight_bias((state)[0], (state)[1], )
    self.training = (state)[2]
    return None
  def _weight_bias(self: __torch__.torch.nn.quantized.modules.linear.LinearPackedParams) -> Tuple[Tensor, Optional[Tensor]]:
    _3 = uninitialized(Tuple[Tensor, Optional[Tensor]])
    if torch.eq(self.dtype, 12):
      _5, _6 = ops.quantized.linear_unpack(self._packed_params)
      _4 = (_5, _6)
    else:
      if torch.eq(self.dtype, 5):
        _8, _9 = ops.quantized.linear_unpack_fp16(self._packed_params)
        _7 = (_8, _9)
      else:
        ops.prim.RaiseException("Exception")
        _7 = _3
      _4 = _7
    return _4
  def set_weight_bias(self: __torch__.torch.nn.quantized.modules.linear.LinearPackedParams,
    weight: Tensor,
    bias: Optional[Tensor]) -> None:
    if torch.eq(self.dtype, 12):
      _10 = ops.quantized.linear_prepack(weight, bias)
      self._packed_params = _10
    else:
      if torch.eq(self.dtype, 5):
        _11 = ops.quantized.linear_prepack_fp16(weight, bias)
        self._packed_params = _11
      else:
        ops.prim.RaiseException("Exception")
    return None
