class LSTM(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  mode : str
  input_size : int
  hidden_size : int
  num_layers : int
  bias : bool
  batch_first : bool
  dropout : float
  bidirectional : bool
  dtype : int
  _all_weight_values : __torch__.torch.nn.modules.container.ModuleList
  def forward_packed(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    input: __torch__.torch.nn.utils.rnn.PackedSequence,
    hx: Optional[Tuple[Tensor, Tensor]]=None) -> Tuple[__torch__.torch.nn.utils.rnn.PackedSequence, Tuple[Tensor, Tensor]]:
    input0, batch_sizes, sorted_indices, unsorted_indices, = input
    max_batch_size = torch.select(batch_sizes, 0, 0)
    max_batch_size0 = int(max_batch_size)
    _0 = (self).forward_impl(input0, hx, batch_sizes, max_batch_size0, sorted_indices, )
    output, hidden, = _0
    output0 = __torch__.torch.nn.utils.rnn.PackedSequence(output, batch_sizes, sorted_indices, unsorted_indices)
    _1 = (self).permute_hidden(hidden, unsorted_indices, )
    return (output0, _1)
  def forward_tensor(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    input: Tensor,
    hx: Optional[Tuple[Tensor, Tensor]]=None) -> Tuple[Tensor, Tuple[Tensor, Tensor]]:
    if self.batch_first:
      max_batch_size = torch.size(input, 0)
    else:
      max_batch_size = torch.size(input, 1)
    _2 = (self).forward_impl(input, hx, None, max_batch_size, None, )
    output, hidden, = _2
    _3 = (self).permute_hidden(hidden, None, )
    return (output, _3)
  def forward_impl(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    input: Tensor,
    hx: Optional[Tuple[Tensor, Tensor]],
    batch_sizes: Optional[Tensor],
    max_batch_size: int,
    sorted_indices: Optional[Tensor]) -> Tuple[Tensor, Tuple[Tensor, Tensor]]:
    if torch.__is__(hx, None):
      if self.bidirectional:
        num_directions = 2
      else:
        num_directions = 1
      _4 = torch.mul(self.num_layers, num_directions)
      _5 = self.hidden_size
      _6 = ops.prim.dtype(input)
      _7 = ops.prim.device(input)
      zeros = torch.zeros([_4, max_batch_size, _5], dtype=_6, layout=None, device=_7, pin_memory=None)
      hx0 = (zeros, zeros)
    else:
      hx1 = unchecked_cast(Tuple[Tensor, Tensor], hx)
      hx2 = (self).permute_hidden(hx1, sorted_indices, )
      hx0 = hx2
    _8 = (self).check_forward_args(input, hx0, batch_sizes, )
    _all_params = annotate(List[__torch__.torch.classes.rnn.CellParamsBase], [])
    _9 = getattr(self._all_weight_values, "0")
    _10 = torch.append(_all_params, _9.param)
    if torch.__is__(batch_sizes, None):
      _11 = self.bias
      _12 = self.num_layers
      _13 = self.dropout
      _14 = self.training
      _15 = self.bidirectional
      _16 = self.batch_first
      _17 = self.dtype
      _18, _19, = hx0
      _20, _21, _22 = torch.quantized_lstm(input, [_18, _19], _all_params, _11, _12, _13, _14, _15, _16, dtype=_17, use_dynamic=True)
      result = (_20, _21, _22)
    else:
      batch_sizes0 = unchecked_cast(Tensor, batch_sizes)
      _23 = self.bias
      _24 = self.num_layers
      _25 = self.dropout
      _26 = self.training
      _27 = self.bidirectional
      _28 = self.dtype
      _29, _30, = hx0
      _31, _32, _33 = torch.quantized_lstm(input, batch_sizes0, [_29, _30], _all_params, _23, _24, _25, _26, _27, dtype=_28, use_dynamic=True)
      result = (_31, _32, _33)
    output = (result)[0]
    hidden = (result)[1:3]
    return (output, hidden)
  def permute_hidden(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    hx: Tuple[Tensor, Tensor],
    permutation: Optional[Tensor]) -> Tuple[Tensor, Tensor]:
    _34 = __torch__.torch.nn.quantized.dynamic.modules.rnn.apply_permutation
    if torch.__is__(permutation, None):
      _35 = hx
    else:
      permutation0 = unchecked_cast(Tensor, permutation)
      _36 = (_34((hx)[0], permutation0, 1, ), _34((hx)[1], permutation0, 1, ))
      _35 = _36
    return _35
  def check_forward_args(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    input: Tensor,
    hidden: Tuple[Tensor, Tensor],
    batch_sizes: Optional[Tensor]) -> None:
    _37 = "Expected hidden[0] size {}, got {}"
    _38 = "Expected hidden[1] size {}, got {}"
    _39 = (self).check_input(input, batch_sizes, )
    expected_hidden_size = (self).get_expected_hidden_size(input, batch_sizes, )
    _40 = (self).check_hidden_size((hidden)[0], expected_hidden_size, _37, )
    _41 = (self).check_hidden_size((hidden)[1], expected_hidden_size, _38, )
    return None
  def check_input(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    input: Tensor,
    batch_sizes: Optional[Tensor]) -> None:
    if torch.__isnot__(batch_sizes, None):
      expected_input_dim = 2
    else:
      expected_input_dim = 3
    _42 = torch.ne(torch.dim(input), expected_input_dim)
    if _42:
      ops.prim.RaiseException("Exception")
    else:
      pass
    _43 = torch.ne(self.input_size, torch.size(input, -1))
    if _43:
      ops.prim.RaiseException("Exception")
    else:
      pass
    return None
  def get_expected_hidden_size(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    input: Tensor,
    batch_sizes: Optional[Tensor]) -> Tuple[int, int, int]:
    if torch.__isnot__(batch_sizes, None):
      batch_sizes1 = unchecked_cast(Tensor, batch_sizes)
      mini_batch0 = torch.select(batch_sizes1, 0, 0)
      mini_batch = int(mini_batch0)
    else:
      if self.batch_first:
        mini_batch1 = torch.size(input, 0)
      else:
        mini_batch1 = torch.size(input, 1)
      mini_batch = mini_batch1
    if self.bidirectional:
      num_directions = 2
    else:
      num_directions = 1
    _44 = torch.mul(self.num_layers, num_directions)
    return (_44, mini_batch, self.hidden_size)
  def check_hidden_size(self: __torch__.torch.nn.quantized.dynamic.modules.rnn.LSTM,
    hx: Tensor,
    expected_hidden_size: Tuple[int, int, int],
    msg: str="Expected hidden size {}, got {}") -> None:
    _45 = torch.size(hx)
    _46, _47, _48, = expected_hidden_size
    if torch.ne(_45, [_46, _47, _48]):
      ops.prim.RaiseException("Exception")
    else:
      pass
    return None
class PackedParameter(Module):
  __parameters__ = []
  __buffers__ = []
  training : bool
  param : __torch__.torch.classes.rnn.CellParamsBase
def apply_permutation(tensor: Tensor,
    permutation: Tensor,
    dim: int=1) -> Tensor:
  _49 = torch.index_select(tensor, dim, permutation)
  return _49
