/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzaar;
import com.google.android.gms.internal.firebase-auth-api.zzam;
import com.google.android.gms.internal.firebase-auth-api.zzas;
import com.google.android.gms.internal.firebase-auth-api.zzbc;
import com.google.android.gms.internal.firebase-auth-api.zzbd;
import com.google.android.gms.internal.firebase-auth-api.zzbe;
import com.google.android.gms.internal.firebase-auth-api.zzbf;
import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbh;
import com.google.android.gms.internal.firebase-auth-api.zzbi;
import com.google.android.gms.internal.firebase-auth-api.zzbj;
import com.google.android.gms.internal.firebase-auth-api.zzho;
import com.google.android.gms.internal.firebase-auth-api.zzht;
import com.google.android.gms.internal.firebase-auth-api.zzym;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzbk {
    private static final Logger zza = Logger.getLogger(zzbk.class.getName());
    private static final ConcurrentMap<String, zzbj> zzb;
    private static final ConcurrentMap<String, zzbi> zzc;
    private static final ConcurrentMap<String, Boolean> zzd;
    private static final ConcurrentMap<String, Object> zze;
    private static final ConcurrentMap<Class<?>, zzbd<?, ?>> zzf;

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized zzbj zzn(String string) throws GeneralSecurityException {
        if (zzb.containsKey(string)) {
            return (zzbj)zzb.get(string);
        }
        string = String.valueOf(string);
        String string2 = "No key manager found for key type ";
        string = string.length() != 0 ? string2.concat(string) : new String(string2);
        GeneralSecurityException generalSecurityException = new GeneralSecurityException(string);
        throw generalSecurityException;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static synchronized void zzo(String string, Class<?> serializable, boolean bl) throws GeneralSecurityException {
        if (!zzb.containsKey(string)) {
            return;
        }
        zzbj zzbj2 = (zzbj)zzb.get(string);
        if (!zzbj2.zzc().equals(serializable)) {
            Object[] objectArray = zza;
            Level level = Level.WARNING;
            Object object = "Attempted overwrite of a registered key manager for key type ";
            if (string.length() != 0) {
                object = ((String)object).concat(string);
            } else {
                String string2 = new String((String)object);
                object = string2;
            }
            objectArray.logp(level, "com.google.crypto.tink.Registry", "ensureKeyManagerInsertable", (String)object);
            objectArray = new Object[]{string, zzbj2.zzc().getName(), ((Class)serializable).getName()};
            object = new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", objectArray));
            throw object;
        }
        if (bl && !((Boolean)zzd.get(string)).booleanValue()) {
            String string3 = "New keys are already disallowed for key type ";
            string = string.length() != 0 ? string3.concat(string) : new String(string3);
            serializable = new GeneralSecurityException(string);
            throw serializable;
        }
    }

    public static synchronized <KeyProtoT extends zzaar> void zza(zzas<KeyProtoT> zzas2, boolean bl) throws GeneralSecurityException {
        String string = zzas2.zzb();
        zzbk.zzo(string, zzas2.getClass(), true);
        if (!zzb.containsKey(string)) {
            ConcurrentMap<String, Object> concurrentMap = zzb;
            Object object = new zzbg(zzas2);
            concurrentMap.put(string, (zzbj)object);
            concurrentMap = zzc;
            object = new zzbi(zzas2);
            concurrentMap.put(string, (zzbj)object);
        }
        zzd.put(string, true);
    }

    public static synchronized <KeyProtoT extends zzaar, PublicKeyProtoT extends zzaar> void zzb(zzbf<KeyProtoT, PublicKeyProtoT> object, zzas<PublicKeyProtoT> zzas2, boolean bl) throws GeneralSecurityException {
        ConcurrentMap<String, zzbi> concurrentMap;
        Object object2 = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPrivateKey";
        zzbk.zzo((String)object2, object.getClass(), true);
        Object[] objectArray = "type.googleapis.com/google.crypto.tink.EciesAeadHkdfPublicKey";
        zzbk.zzo((String)objectArray, zzas2.getClass(), false);
        if (!zzb.containsKey(object2) || (concurrentMap = ((zzbj)zzb.get(object2)).zze()) == null || concurrentMap.equals(zzas2.getClass())) {
            if (!zzb.containsKey(object2) || ((zzbj)zzb.get(object2)).zze() == null) {
                concurrentMap = zzb;
                Object object3 = new zzbh((zzbf)object, zzas2);
                concurrentMap.put((String)object2, (zzbi)object3);
                concurrentMap = zzc;
                object3 = new zzbi((zzas)object);
                concurrentMap.put((String)object2, (zzbi)object3);
            }
            zzd.put((String)object2, true);
            if (!zzb.containsKey(objectArray)) {
                object = zzb;
                object2 = new zzbg(zzas2);
                object.put(objectArray, object2);
            }
        } else {
            Logger logger = zza;
            Level level = Level.WARNING;
            StringBuilder stringBuilder = new StringBuilder(219);
            stringBuilder.append("Attempted overwrite of a registered key manager for key type ");
            stringBuilder.append((String)object2);
            stringBuilder.append(" with inconsistent public key type ");
            stringBuilder.append((String)objectArray);
            logger.logp(level, "com.google.crypto.tink.Registry", "registerAsymmetricKeyManagers", stringBuilder.toString());
            objectArray = new Object[]{object.getClass().getName(), ((Class)((Object)concurrentMap)).getName(), zzas2.getClass().getName()};
            object2 = new GeneralSecurityException(String.format("public key manager corresponding to %s is already registered with %s, cannot be re-registered with %s", objectArray));
            throw object2;
        }
        zzd.put((String)objectArray, false);
    }

    public static synchronized <B, P> void zzc(zzbd<B, P> object) throws GeneralSecurityException {
        if (object == null) {
            object = new IllegalArgumentException("wrapper must be non-null");
            throw object;
        }
        Class<P> clazz = object.zzb();
        if (zzf.containsKey(clazz)) {
            zzbd zzbd2 = (zzbd)zzf.get(clazz);
            if (!object.getClass().equals(zzbd2.getClass())) {
                Object object2 = zza;
                Object[] objectArray = Level.WARNING;
                String string = String.valueOf(clazz);
                String string2 = String.valueOf(string);
                int n = string2.length();
                StringBuilder stringBuilder = new StringBuilder(n + 56);
                stringBuilder.append("Attempted overwrite of a registered SetWrapper for type ");
                stringBuilder.append(string);
                ((Logger)object2).logp((Level)objectArray, "com.google.crypto.tink.Registry", "registerPrimitiveWrapper", stringBuilder.toString());
                objectArray = new Object[]{clazz.getName(), zzbd2.getClass().getName(), object.getClass().getName()};
                object2 = new GeneralSecurityException(String.format("SetWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", objectArray));
                throw object2;
            }
        }
        zzf.put(clazz, (zzbd<?, ?>)object);
    }

    public static zzam<?> zzd(String string) throws GeneralSecurityException {
        return zzbk.zzn(string).zzb();
    }

    private static <P> zzam<P> zzp(String set, Class<P> object) throws GeneralSecurityException {
        set = zzbk.zzn((String)((Object)set));
        if (object == null) {
            return set.zzb();
        }
        if (set.zzd().contains(object)) {
            return set.zza(object);
        }
        object = ((Class)object).getName();
        String string = String.valueOf(set.zzc());
        set = set.zzd();
        CharSequence charSequence = new StringBuilder();
        Object object2 = set.iterator();
        boolean bl = true;
        while (true) {
            Object object3;
            if (object2.hasNext()) {
                object3 = object2.next();
                if (!bl) {
                    ((StringBuilder)charSequence).append(", ");
                }
            } else {
                String string2 = ((StringBuilder)charSequence).toString();
                charSequence = String.valueOf(object);
                int n = ((String)charSequence).length();
                object2 = String.valueOf(string);
                int n2 = ((String)object2).length();
                object3 = String.valueOf(string2);
                int n3 = ((String)object3).length();
                StringBuilder stringBuilder = new StringBuilder(n + 77 + n2 + n3);
                stringBuilder.append("Primitive type ");
                stringBuilder.append((String)object);
                stringBuilder.append(" not supported by key manager of type ");
                stringBuilder.append(string);
                stringBuilder.append(", supported primitives: ");
                stringBuilder.append(string2);
                GeneralSecurityException generalSecurityException = new GeneralSecurityException(stringBuilder.toString());
                throw generalSecurityException;
            }
            ((StringBuilder)charSequence).append(((Class)object3).getCanonicalName());
            bl = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static synchronized zzho zze(zzht object) throws GeneralSecurityException {
        Object object2 = zzbk.zzd(((zzht)object).zza());
        if (((Boolean)zzd.get(((zzht)object).zza())).booleanValue()) {
            return object2.zzd(((zzht)object).zzb());
        }
        object = String.valueOf(((zzht)object).zza());
        String string = "newKey-operation not permitted for key type ";
        object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
        object2 = new GeneralSecurityException((String)object);
        throw object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static synchronized zzaar zzf(zzht object) throws GeneralSecurityException {
        Object object2 = zzbk.zzd(((zzht)object).zza());
        if (((Boolean)zzd.get(((zzht)object).zza())).booleanValue()) {
            return object2.zzc(((zzht)object).zzb());
        }
        object = String.valueOf(((zzht)object).zza());
        String string = "newKey-operation not permitted for key type ";
        object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
        object2 = new GeneralSecurityException((String)object);
        throw object2;
    }

    public static zzho zzg(String string, zzym serializable) throws GeneralSecurityException {
        zzam zzam2 = zzbk.zzp(string, null);
        if (!(zzam2 instanceof zzbe)) {
            zzam2 = String.valueOf(string);
            int n = ((String)((Object)zzam2)).length();
            StringBuilder stringBuilder = new StringBuilder(n + 48);
            stringBuilder.append("manager for key type ");
            stringBuilder.append(string);
            stringBuilder.append(" is not a PrivateKeyManager");
            serializable = new GeneralSecurityException(stringBuilder.toString());
            throw serializable;
        }
        return ((zzbe)zzam2).zze((zzym)serializable);
    }

    public static <P> P zzh(String string, zzaar zzaar2, Class<P> clazz) throws GeneralSecurityException {
        return zzbk.zzp(string, clazz).zzb(zzaar2);
    }

    private static <P> P zzq(String string, zzym zzym2, Class<P> clazz) throws GeneralSecurityException {
        return zzbk.zzp(string, clazz).zza(zzym2);
    }

    public static <P> P zzi(String string, byte[] byArray, Class<P> clazz) throws GeneralSecurityException {
        return zzbk.zzq(string, zzym.zzm(byArray), clazz);
    }

    @Deprecated
    public static <P> P zzj(zzho zzho2) throws GeneralSecurityException {
        return zzbk.zzq(zzho2.zza(), zzho2.zzb(), null);
    }

    public static <P> P zzk(zzho zzho2, Class<P> clazz) throws GeneralSecurityException {
        return zzbk.zzq(zzho2.zza(), zzho2.zzb(), clazz);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static <B, P> P zzl(zzbc<B> object, Class<P> object2) throws GeneralSecurityException {
        if ((object2 = (zzbd)zzf.get(object2)) == null) {
            object = String.valueOf(((zzbc)object).zze().getName());
            String string = "No wrapper found for ";
            object = ((String)object).length() != 0 ? string.concat((String)object) : new String(string);
            object2 = new GeneralSecurityException((String)object);
            throw object2;
        }
        if (!object2.zzc().equals(((zzbc)object).zze())) {
            object2 = String.valueOf(object2.zzc());
            object = String.valueOf(((zzbc)object).zze());
            String string = String.valueOf(object2);
            int n = string.length();
            String string2 = String.valueOf(object);
            int n2 = string2.length();
            StringBuilder stringBuilder = new StringBuilder(n + 44 + n2);
            stringBuilder.append("Wrong input primitive class, expected ");
            stringBuilder.append((String)object2);
            stringBuilder.append(", got ");
            stringBuilder.append((String)object);
            GeneralSecurityException generalSecurityException = new GeneralSecurityException(stringBuilder.toString());
            throw generalSecurityException;
        }
        return object2.zza(object);
    }

    public static Class<?> zzm(Class<?> object) {
        if ((object = (zzbd)zzf.get(object)) == null) {
            return null;
        }
        return object.zzc();
    }

    private zzbk() {
    }

    static {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        zzb = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zzc = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zzd = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zze = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        zzf = concurrentHashMap;
    }
}

