/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.util.Log;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.ProviderException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class zzdl
implements zzag {
    private static final String zza = zzdl.class.getSimpleName();
    private final SecretKey zzb;

    /*
     * Enabled aggressive block sorting
     */
    zzdl(String string, KeyStore object) throws GeneralSecurityException {
        ((zzdl)object2).zzb = (SecretKey)((KeyStore)object).getKey(string, null);
        if (((zzdl)object2).zzb != null) {
            return;
        }
        Object object2 = String.valueOf(string);
        string = "Keystore cannot load the key with ID: ";
        object2 = ((String)object2).length() != 0 ? string.concat((String)object2) : new String(string);
        object = new InvalidKeyException((String)object2);
        throw object;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        try {
            byte[] byArray3 = this.zzc(byArray, byArray2);
            return byArray3;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zza, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)exception);
            zzdl.zze();
            return this.zzc(byArray, byArray2);
        }
    }

    private final byte[] zzc(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        if (n > 2147483619) {
            Object object = new GeneralSecurityException("plaintext too long");
            throw object;
        }
        byte[] byArray3 = new byte[n + 28];
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, ((zzdl)object).zzb);
        cipher.updateAAD(byArray2);
        cipher.doFinal(byArray, 0, n, byArray3, 12);
        System.arraycopy(cipher.getIV(), 0, byArray3, 0, 12);
        return byArray3;
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        try {
            byte[] byArray3 = this.zzd(byArray, byArray2);
            return byArray3;
        }
        catch (GeneralSecurityException | ProviderException exception) {
            Log.w((String)zza, (String)"encountered a potentially transient KeyStore error, will wait and retry", (Throwable)exception);
            zzdl.zze();
            return this.zzd(byArray, byArray2);
        }
    }

    private final byte[] zzd(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n = byArray.length;
        if (n < 28) {
            Object object = new GeneralSecurityException("ciphertext too short");
            throw object;
        }
        GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(128, byArray, 0, 12);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)((zzdl)object).zzb, gCMParameterSpec);
        cipher.updateAAD(byArray2);
        return cipher.doFinal(byArray, 12, n + -12);
    }

    private static void zze() {
        int n = (int)(Math.random() * 100.0);
        try {
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

