/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.MultiFactorSession;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.PhoneMultiFactorInfo;
import com.google.firebase.auth.internal.zzag;
import com.google.firebase.auth.zzad;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class PhoneAuthOptions {
    private final FirebaseAuth zza;
    private Long zzb;
    private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzc;
    private Executor zzd;
    @Nullable
    private String zze;
    private Activity zzf;
    @Nullable
    private PhoneAuthProvider.ForceResendingToken zzg;
    @Nullable
    private MultiFactorSession zzh;
    @Nullable
    private PhoneMultiFactorInfo zzi;
    private boolean zzj;

    @NonNull
    public static Builder newBuilder() {
        Builder builder = new Builder(FirebaseAuth.getInstance());
        return builder;
    }

    @NonNull
    public static Builder newBuilder(@NonNull FirebaseAuth firebaseAuth) {
        Builder builder = new Builder(firebaseAuth);
        return builder;
    }

    @NonNull
    public final FirebaseAuth zza() {
        return this.zza;
    }

    public final String zzb() {
        return this.zze;
    }

    public final Long zzc() {
        return this.zzb;
    }

    public final PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd() {
        return this.zzc;
    }

    public final Executor zze() {
        return this.zzd;
    }

    @Nullable
    public final PhoneAuthProvider.ForceResendingToken zzf() {
        return this.zzg;
    }

    @Nullable
    public final MultiFactorSession zzg() {
        return this.zzh;
    }

    public final boolean zzh() {
        return this.zzj;
    }

    @Nullable
    public final Activity zzi() {
        return this.zzf;
    }

    @Nullable
    public final PhoneMultiFactorInfo zzj() {
        return this.zzi;
    }

    public final boolean zzk() {
        return this.zzh != null;
    }

    /* synthetic */ PhoneAuthOptions(FirebaseAuth firebaseAuth, Long l, PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, Executor executor, String string, Activity activity, PhoneAuthProvider.ForceResendingToken forceResendingToken, MultiFactorSession multiFactorSession, PhoneMultiFactorInfo phoneMultiFactorInfo, boolean bl, zzad zzad2) {
        this.zza = firebaseAuth;
        this.zze = string;
        this.zzb = l;
        this.zzc = onVerificationStateChangedCallbacks;
        this.zzf = activity;
        this.zzd = executor;
        this.zzg = forceResendingToken;
        this.zzh = multiFactorSession;
        this.zzi = phoneMultiFactorInfo;
        this.zzj = bl;
    }

    public static final class Builder {
        private final FirebaseAuth zza;
        private String zzb;
        private Long zzc;
        private PhoneAuthProvider.OnVerificationStateChangedCallbacks zzd;
        private Executor zze;
        private Activity zzf;
        private PhoneAuthProvider.ForceResendingToken zzg;
        private MultiFactorSession zzh;
        private PhoneMultiFactorInfo zzi;
        private boolean zzj;

        public Builder(@NonNull FirebaseAuth firebaseAuth) {
            this.zza = (FirebaseAuth)Preconditions.checkNotNull((Object)firebaseAuth);
        }

        @NonNull
        public Builder setPhoneNumber(@NonNull String string) {
            this.zzb = string;
            return this;
        }

        @NonNull
        public Builder setMultiFactorHint(@NonNull PhoneMultiFactorInfo phoneMultiFactorInfo) {
            this.zzi = phoneMultiFactorInfo;
            return this;
        }

        @NonNull
        public Builder setTimeout(@NonNull Long l, @NonNull TimeUnit timeUnit) {
            this.zzc = TimeUnit.SECONDS.convert(l, timeUnit);
            return this;
        }

        @NonNull
        public Builder setCallbacks(@NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks) {
            this.zzd = onVerificationStateChangedCallbacks;
            return this;
        }

        @NonNull
        public Builder setActivity(@NonNull Activity activity) {
            this.zzf = activity;
            return this;
        }

        @NonNull
        public Builder setForceResendingToken(@NonNull PhoneAuthProvider.ForceResendingToken forceResendingToken) {
            this.zzg = forceResendingToken;
            return this;
        }

        @NonNull
        public Builder setMultiFactorSession(@NonNull MultiFactorSession multiFactorSession) {
            this.zzh = multiFactorSession;
            return this;
        }

        @NonNull
        public Builder requireSmsValidation(boolean bl) {
            this.zzj = bl;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public PhoneAuthOptions build() {
            boolean bl;
            Preconditions.checkNotNull((Object)((Builder)object).zza, (Object)"FirebaseAuth instance cannot be null");
            Preconditions.checkNotNull((Object)((Builder)object).zzc, (Object)"You must specify an auto-retrieval timeout; please call #setTimeout()");
            Preconditions.checkNotNull((Object)((Builder)object).zzd, (Object)"You must specify callbacks on your PhoneAuthOptions. Please call #setCallbacks()");
            Preconditions.checkNotNull((Object)((Builder)object).zzf, (Object)"You must specify an Activity on your PhoneAuthOptions. Please call #setActivity()");
            ((Builder)object).zze = TaskExecutors.MAIN_THREAD;
            if (((Builder)object).zzc < 0L || ((Builder)object).zzc > 120L) {
                Object object = new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
                throw object;
            }
            MultiFactorSession multiFactorSession = ((Builder)object).zzh;
            if (multiFactorSession == null) {
                Preconditions.checkNotEmpty((String)((Builder)object).zzb, (Object)"The given phoneNumber is empty. Please set a non-empty phone number with #setPhoneNumber()");
                Preconditions.checkArgument((boolean)(((Builder)object).zzj ^ true), (Object)"You cannot require sms validation without setting a multi-factor session.");
                bl = ((Builder)object).zzi == null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                return new PhoneAuthOptions(((Builder)object).zza, ((Builder)object).zzc, ((Builder)object).zzd, ((Builder)object).zze, ((Builder)object).zzb, ((Builder)object).zzf, ((Builder)object).zzg, ((Builder)object).zzh, ((Builder)object).zzi, ((Builder)object).zzj, null);
            } else if (((zzag)multiFactorSession).zze()) {
                Preconditions.checkNotEmpty((String)((Builder)object).zzb);
                bl = ((Builder)object).zzi == null;
                Preconditions.checkArgument((boolean)bl, (Object)"Invalid MultiFactorSession - use the getSession method in MultiFactorResolver to get a valid sign-in session.");
                return new PhoneAuthOptions(((Builder)object).zza, ((Builder)object).zzc, ((Builder)object).zzd, ((Builder)object).zze, ((Builder)object).zzb, ((Builder)object).zzf, ((Builder)object).zzg, ((Builder)object).zzh, ((Builder)object).zzi, ((Builder)object).zzj, null);
            } else {
                bl = ((Builder)object).zzi != null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phoneMultiFactorInfo must be set for second factor sign-in.");
                bl = ((Builder)object).zzb == null;
                Preconditions.checkArgument((boolean)bl, (Object)"A phone number must not be set for MFA sign-in. A PhoneMultiFactorInfo should be set instead.");
            }
            return new PhoneAuthOptions(((Builder)object).zza, ((Builder)object).zzc, ((Builder)object).zzd, ((Builder)object).zze, ((Builder)object).zzb, ((Builder)object).zzf, ((Builder)object).zzg, ((Builder)object).zzh, ((Builder)object).zzi, ((Builder)object).zzj, null);
        }
    }
}

