/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.iid;

import android.os.Build;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.concurrent.NamedThreadFactory;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.heartbeatinfo.HeartBeatInfo;
import com.google.firebase.iid.FirebaseIidExecutors;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$0;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$1;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$2;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$3;
import com.google.firebase.iid.FirebaseInstanceId$$Lambda$4;
import com.google.firebase.iid.GmsRpc;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.iid.InstanceIdResultImpl;
import com.google.firebase.iid.Metadata;
import com.google.firebase.iid.RequestDeduplicator;
import com.google.firebase.iid.Store;
import com.google.firebase.iid.SyncTask;
import com.google.firebase.inject.Provider;
import com.google.firebase.installations.FirebaseInstallationsApi;
import com.google.firebase.platforminfo.UserAgentPublisher;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

@Deprecated
public class FirebaseInstanceId {
    private static final long MAX_DELAY_SEC = TimeUnit.HOURS.toSeconds(8L);
    private static Store store;
    private static final Pattern API_KEY_FORMAT;
    @GuardedBy(value="FirebaseInstanceId.class")
    @VisibleForTesting
    static ScheduledExecutorService syncExecutor;
    @VisibleForTesting
    final Executor fileIoExecutor;
    private final FirebaseApp app;
    private final Metadata metadata;
    private final GmsRpc rpc;
    private final RequestDeduplicator requestDeduplicator;
    private final FirebaseInstallationsApi firebaseInstallations;
    @GuardedBy(value="this")
    private boolean syncScheduledOrRunning;

    @NonNull
    public static FirebaseInstanceId getInstance() {
        return FirebaseInstanceId.getInstance(FirebaseApp.getInstance());
    }

    @Keep
    @NonNull
    public static FirebaseInstanceId getInstance(@NonNull FirebaseApp object) {
        FirebaseInstanceId.checkRequiredFirebaseOptions(object);
        object = (FirebaseInstanceId)object.get(FirebaseInstanceId.class);
        Preconditions.checkNotNull((Object)object, (Object)"Firebase Instance ID component is not present");
        return object;
    }

    FirebaseInstanceId(FirebaseApp firebaseApp, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        Metadata metadata = new Metadata(firebaseApp.getApplicationContext());
        this(firebaseApp, metadata, FirebaseIidExecutors.newCachedSingleThreadExecutor(), FirebaseIidExecutors.newCachedSingleThreadExecutor(), provider, provider2, firebaseInstallationsApi);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    FirebaseInstanceId(FirebaseApp object, Metadata metadata, Executor executor, Executor executor2, Provider<UserAgentPublisher> provider, Provider<HeartBeatInfo> provider2, FirebaseInstallationsApi firebaseInstallationsApi) {
        ((FirebaseInstanceId)object2).syncScheduledOrRunning = false;
        if (Metadata.getDefaultSenderId(object) == null) {
            Object object2 = new IllegalStateException("FirebaseInstanceId failed to initialize, FirebaseApp is missing project ID");
            throw object2;
        }
        Object object3 = FirebaseInstanceId.class;
        synchronized (object3) {
            Store store = FirebaseInstanceId.store;
            if (store == null) {
                FirebaseInstanceId.store = store = new Store(object.getApplicationContext());
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl12 : MonitorExitStatement: MONITOREXIT : var8_9
            ((FirebaseInstanceId)object2).app = object;
            ((FirebaseInstanceId)object2).metadata = metadata;
            ((FirebaseInstanceId)object2).rpc = object3 = new GmsRpc((FirebaseApp)object, metadata, provider, provider2, firebaseInstallationsApi);
            ((FirebaseInstanceId)object2).fileIoExecutor = executor2;
            super(executor);
            ((FirebaseInstanceId)object2).requestDeduplicator = object;
            ((FirebaseInstanceId)object2).firebaseInstallations = firebaseInstallationsApi;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    private void startSyncIfNecessary() {
        if (this.tokenNeedsRefresh(this.getTokenWithoutTriggeringSync())) {
            this.startSync();
            return;
        }
    }

    FirebaseApp getApp() {
        return this.app;
    }

    synchronized void setSyncScheduledOrRunning(boolean bl) {
        this.syncScheduledOrRunning = bl;
    }

    synchronized void startSync() {
        if (!this.syncScheduledOrRunning) {
            this.syncWithDelaySecondsInternal(0L);
            return;
        }
    }

    synchronized void syncWithDelaySecondsInternal(long l) {
        long l2 = Math.max(30L, l + l);
        long l3 = MAX_DELAY_SEC;
        l2 = Math.min(l2, l3);
        SyncTask syncTask = new SyncTask(this, l2);
        this.enqueueTaskWithDelaySeconds(syncTask, l);
        this.syncScheduledOrRunning = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void enqueueTaskWithDelaySeconds(Runnable runnable, long l) {
        Class<FirebaseInstanceId> clazz = FirebaseInstanceId.class;
        synchronized (clazz) {
            ScheduledExecutorService scheduledExecutorService = syncExecutor;
            if (scheduledExecutorService == null) {
                NamedThreadFactory namedThreadFactory = new NamedThreadFactory("FirebaseInstanceId");
                syncExecutor = scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)namedThreadFactory);
            }
            syncExecutor.schedule(runnable, l, TimeUnit.SECONDS);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @Deprecated
    @WorkerThread
    @NonNull
    public String getId() {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        this.startSyncIfNecessary();
        return this.getIdWithoutTriggeringSync();
    }

    private static void checkRequiredFirebaseOptions(@NonNull FirebaseApp firebaseApp) {
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getProjectId(), (Object)"Please set your project ID. A valid Firebase project ID is required to communicate with Firebase server APIs: It identifies your project with Google.");
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getApplicationId(), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.");
        Preconditions.checkNotEmpty((String)firebaseApp.getOptions().getApiKey(), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.");
        Preconditions.checkArgument((boolean)FirebaseInstanceId.isValidAppIdFormat(firebaseApp.getOptions().getApplicationId()), (Object)"Please set your Application ID. A valid Firebase App ID is required to communicate with Firebase server APIs: It identifies your application with Firebase.Please refer to https://firebase.google.com/support/privacy/init-options.");
        Preconditions.checkArgument((boolean)FirebaseInstanceId.isValidApiKeyFormat(firebaseApp.getOptions().getApiKey()), (Object)"Please set a valid API key. A Firebase API key is required to communicate with Firebase server APIs: It authenticates your project with Google.Please refer to https://firebase.google.com/support/privacy/init-options.");
    }

    static boolean isValidAppIdFormat(@Nonnull String string) {
        return string.contains(":");
    }

    static boolean isValidApiKeyFormat(@Nonnull String string) {
        return API_KEY_FORMAT.matcher(string).matches();
    }

    String getIdWithoutTriggeringSync() {
        try {
            store.setCreationTime(((FirebaseInstanceId)((Object)string)).app.getPersistenceKey());
            String string = (String)FirebaseInstanceId.awaitTaskAllowOnMainThread(((FirebaseInstanceId)((Object)string)).firebaseInstallations.getId());
        }
        catch (InterruptedException interruptedException) {
            IllegalStateException illegalStateException = new IllegalStateException(interruptedException);
            throw illegalStateException;
        }
        return string;
    }

    public long getCreationTime() {
        return store.getCreationTime(this.app.getPersistenceKey());
    }

    @Deprecated
    @NonNull
    public Task<InstanceIdResult> getInstanceId() {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        return this.getInstanceId(Metadata.getDefaultSenderId(this.app), "*");
    }

    private Task<InstanceIdResult> getInstanceId(String string, String string2) {
        string2 = FirebaseInstanceId.rationaliseScope(string2);
        Task task = Tasks.forResult(null);
        Executor executor = this.fileIoExecutor;
        FirebaseInstanceId$$Lambda$0 firebaseInstanceId$$Lambda$0 = new FirebaseInstanceId$$Lambda$0(this, string, string2);
        return task.continueWithTask(executor, (Continuation)firebaseInstanceId$$Lambda$0);
    }

    @Deprecated
    @WorkerThread
    public void deleteInstanceId() throws IOException {
        FirebaseInstanceId.checkRequiredFirebaseOptions(((FirebaseInstanceId)object).app);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            Object object = new IOException("MAIN_THREAD");
            throw object;
        }
        ((FirebaseInstanceId)object).awaitTask(((FirebaseInstanceId)object).firebaseInstallations.delete());
        ((FirebaseInstanceId)object).resetStorage();
    }

    @Deprecated
    @Nullable
    public String getToken() {
        FirebaseInstanceId.checkRequiredFirebaseOptions(this.app);
        Store.Token token = this.getTokenWithoutTriggeringSync();
        if (this.tokenNeedsRefresh(token)) {
            this.startSync();
        }
        return Store.Token.getTokenOrNull(token);
    }

    @Deprecated
    @Nullable
    @WorkerThread
    public String getToken(@NonNull String string, @NonNull String string2) throws IOException {
        FirebaseInstanceId.checkRequiredFirebaseOptions(((FirebaseInstanceId)object).app);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            Object object = new IOException("MAIN_THREAD");
            throw object;
        }
        return ((FirebaseInstanceId)object).awaitTask(super.getInstanceId(string, string2)).getToken();
    }

    @Nullable
    Store.Token getTokenWithoutTriggeringSync() {
        return this.getTokenWithoutTriggeringSync(Metadata.getDefaultSenderId(this.app), "*");
    }

    @Nullable
    @VisibleForTesting
    Store.Token getTokenWithoutTriggeringSync(String string, String string2) {
        return store.getToken(this.getSubtype(), string, string2);
    }

    String blockingGetMasterToken() throws IOException {
        return this.getToken(Metadata.getDefaultSenderId(this.app), "*");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T awaitTask(Task<T> object) throws IOException {
        Object object2;
        Throwable throwable;
        try {
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            Object object3 = Tasks.await(object, (long)30000L, (TimeUnit)timeUnit);
            return (T)object3;
        }
        catch (ExecutionException executionException) {
            throwable = executionException.getCause();
            if (throwable instanceof IOException) {
                if (!"INSTANCE_ID_RESET".equals(throwable.getMessage())) throw (IOException)throwable;
                ((FirebaseInstanceId)object2).resetStorage();
                throw (IOException)throwable;
            }
        }
        catch (InterruptedException | TimeoutException exception) {
            object2 = new IOException("SERVICE_NOT_AVAILABLE");
            throw object2;
        }
        if (throwable instanceof RuntimeException) throw (RuntimeException)throwable;
        object2 = new IOException(executionException);
        throw object2;
    }

    private static <T> T awaitTaskAllowOnMainThread(@NonNull Task<T> task) throws InterruptedException {
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Executor executor = FirebaseInstanceId$$Lambda$1.$instance;
        FirebaseInstanceId$$Lambda$2 firebaseInstanceId$$Lambda$2 = new FirebaseInstanceId$$Lambda$2(countDownLatch);
        task.addOnCompleteListener(executor, (OnCompleteListener)firebaseInstanceId$$Lambda$2);
        countDownLatch.await(30000L, TimeUnit.MILLISECONDS);
        return FirebaseInstanceId.getResultOrThrowException(task);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T> T getResultOrThrowException(@NonNull Task<T> object) {
        if (object.isSuccessful()) {
            return (T)object.getResult();
        }
        if (object.isCanceled()) {
            CancellationException cancellationException = new CancellationException("Task is already canceled");
            throw cancellationException;
        }
        if (!object.isComplete()) {
            IllegalThreadStateException illegalThreadStateException = new IllegalThreadStateException("Firebase Installations getId Task has timed out.");
            throw illegalThreadStateException;
        }
        IllegalStateException illegalStateException = new IllegalStateException(object.getException());
        throw illegalStateException;
    }

    @Deprecated
    @WorkerThread
    public void deleteToken(@NonNull String string, @NonNull String string2) throws IOException {
        FirebaseInstanceId.checkRequiredFirebaseOptions(((FirebaseInstanceId)object).app);
        if (Looper.getMainLooper() == Looper.myLooper()) {
            Object object = new IOException("MAIN_THREAD");
            throw object;
        }
        string2 = FirebaseInstanceId.rationaliseScope(string2);
        String string3 = ((FirebaseInstanceId)object).getIdWithoutTriggeringSync();
        super.awaitTask(((FirebaseInstanceId)object).rpc.deleteToken(string3, string, string2));
        store.deleteToken(super.getSubtype(), string, string2);
    }

    @VisibleForTesting
    @KeepForSdk
    public static synchronized void clearInstancesForTest() {
        if (syncExecutor != null) {
            syncExecutor.shutdownNow();
        }
        syncExecutor = null;
        store = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isDebugLogEnabled() {
        if (Log.isLoggable((String)"FirebaseInstanceId", (int)3)) return true;
        if (Build.VERSION.SDK_INT != 23) return false;
        if (!Log.isLoggable((String)"FirebaseInstanceId", (int)3)) return false;
        return true;
    }

    synchronized void resetStorage() {
        store.deleteAll();
    }

    @VisibleForTesting
    public boolean isGmsCorePresent() {
        return this.metadata.isGmscorePresent();
    }

    @VisibleForTesting
    @KeepForSdk
    public boolean isFcmAutoInitEnabled() {
        Object object = new IllegalStateException("FirebaseMessaging version not supported. Update to latest version.");
        throw object;
    }

    @VisibleForTesting
    @KeepForSdk
    public void setFcmAutoInitEnabled(boolean bl) {
        Object object = new IllegalStateException("FirebaseMessaging version not supported. Update to latest version.");
        throw object;
    }

    private static String rationaliseScope(String string) {
        if (string.isEmpty() || string.equalsIgnoreCase("fcm") || string.equalsIgnoreCase("gcm")) {
            return "*";
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getSubtype() {
        if (!"[DEFAULT]".equals(((FirebaseInstanceId)this).app.getName())) return ((FirebaseInstanceId)this).app.getPersistenceKey();
        return "";
    }

    boolean tokenNeedsRefresh(@Nullable Store.Token token) {
        return token == null || token.needsRefresh(this.metadata.getAppVersionCode());
    }

    static final /* synthetic */ void lambda$awaitTaskAllowOnMainThread$3$FirebaseInstanceId(CountDownLatch countDownLatch, Task task) {
        countDownLatch.countDown();
    }

    final /* synthetic */ Task lambda$getInstanceId$2$FirebaseInstanceId(String string, String string2, Task object) throws Exception {
        object = ((FirebaseInstanceId)object3).getIdWithoutTriggeringSync();
        Object object2 = ((FirebaseInstanceId)object3).getTokenWithoutTriggeringSync(string, string2);
        if (!((FirebaseInstanceId)object3).tokenNeedsRefresh((Store.Token)object2)) {
            Object object3 = new InstanceIdResultImpl((String)object, ((Store.Token)object2).token);
            return Tasks.forResult((Object)object3);
        }
        object2 = ((FirebaseInstanceId)object3).requestDeduplicator;
        FirebaseInstanceId$$Lambda$3 firebaseInstanceId$$Lambda$3 = new FirebaseInstanceId$$Lambda$3((FirebaseInstanceId)object3, (String)object, string, string2);
        return ((RequestDeduplicator)object2).getOrStartGetTokenRequest(string, string2, firebaseInstanceId$$Lambda$3);
    }

    final /* synthetic */ Task lambda$getInstanceId$1$FirebaseInstanceId(String string, String string2, String string3) {
        Task<String> task = this.rpc;
        task = task.getToken(string, string2, string3);
        Executor executor = this.fileIoExecutor;
        FirebaseInstanceId$$Lambda$4 firebaseInstanceId$$Lambda$4 = new FirebaseInstanceId$$Lambda$4(this, string2, string3, string);
        return task.onSuccessTask(executor, (SuccessContinuation)firebaseInstanceId$$Lambda$4);
    }

    final /* synthetic */ Task lambda$getInstanceId$0$FirebaseInstanceId(String string, String string2, String string3, String string4) throws Exception {
        store.saveToken(((FirebaseInstanceId)object).getSubtype(), string, string2, string4, ((FirebaseInstanceId)object).metadata.getAppVersionCode());
        Object object = new InstanceIdResultImpl(string3, string4);
        return Tasks.forResult((Object)object);
    }

    static {
        API_KEY_FORMAT = Pattern.compile("\\AA[\\w-]{38}\\z");
    }
}

