/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.app.Activity;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCanceledListener;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.RuntimeExecutionException;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzc;
import com.google.android.gms.tasks.zze;
import com.google.android.gms.tasks.zzg;
import com.google.android.gms.tasks.zzi;
import com.google.android.gms.tasks.zzk;
import com.google.android.gms.tasks.zzm;
import com.google.android.gms.tasks.zzo;
import com.google.android.gms.tasks.zzq;
import com.google.android.gms.tasks.zzr;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

final class zzu<TResult>
extends Task<TResult> {
    private final Object mLock = new Object();
    private final zzr<TResult> zzx = new zzr();
    @GuardedBy(value="mLock")
    private boolean zzy;
    private volatile boolean zzz;
    @GuardedBy(value="mLock")
    private TResult zzaa;
    @GuardedBy(value="mLock")
    private Exception zzab;

    zzu() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isComplete() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzy;
        }
    }

    @Override
    public final boolean isCanceled() {
        return this.zzz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isSuccessful() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzy && !this.zzz && this.zzab == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final TResult getResult() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzb();
            this.zzd();
            if (this.zzab != null) {
                throw new RuntimeExecutionException(this.zzab);
            }
            return this.zzaa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <X extends Throwable> TResult getResult(@NonNull Class<X> clazz) throws X {
        Object object = this.mLock;
        synchronized (object) {
            this.zzb();
            this.zzd();
            if (clazz.isInstance(this.zzab)) {
                throw (Throwable)clazz.cast(this.zzab);
            }
            if (this.zzab != null) {
                throw new RuntimeExecutionException(this.zzab);
            }
            return this.zzaa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final Exception getException() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzab;
        }
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        return ((Task)this).addOnSuccessListener(TaskExecutors.MAIN_THREAD, onSuccessListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Executor executor, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        this.zzx.zza(new zzm<TResult>(executor, onSuccessListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnSuccessListener(@NonNull Activity activity, @NonNull OnSuccessListener<? super TResult> onSuccessListener) {
        zzm<? super TResult> zzm2 = new zzm<TResult>(TaskExecutors.MAIN_THREAD, onSuccessListener);
        this.zzx.zza(zzm2);
        zza.zza(activity).zzb(zzm2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull OnFailureListener onFailureListener) {
        return ((Task)this).addOnFailureListener(TaskExecutors.MAIN_THREAD, onFailureListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Executor executor, @NonNull OnFailureListener onFailureListener) {
        this.zzx.zza(new zzk(executor, onFailureListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnFailureListener(@NonNull Activity activity, @NonNull OnFailureListener onFailureListener) {
        zzk zzk2 = new zzk(TaskExecutors.MAIN_THREAD, onFailureListener);
        this.zzx.zza(zzk2);
        zza.zza(activity).zzb(zzk2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull OnCompleteListener<TResult> onCompleteListener) {
        return ((Task)this).addOnCompleteListener(TaskExecutors.MAIN_THREAD, onCompleteListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Executor executor, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        this.zzx.zza(new zzi<TResult>(executor, onCompleteListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCompleteListener(@NonNull Activity activity, @NonNull OnCompleteListener<TResult> onCompleteListener) {
        zzi<TResult> zzi2 = new zzi<TResult>(TaskExecutors.MAIN_THREAD, onCompleteListener);
        this.zzx.zza(zzi2);
        zza.zza(activity).zzb(zzi2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Continuation<TResult, TContinuationResult> continuation) {
        return ((Task)this).continueWith(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWith(@NonNull Executor executor, @NonNull Continuation<TResult, TContinuationResult> continuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzx.zza(new zzc<TResult, TContinuationResult>(executor, continuation, zzu2));
        this.zze();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        return ((Task)this).continueWithTask(TaskExecutors.MAIN_THREAD, continuation);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull OnCanceledListener onCanceledListener) {
        return ((Task)this).addOnCanceledListener(TaskExecutors.MAIN_THREAD, onCanceledListener);
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull Executor executor, @NonNull OnCanceledListener onCanceledListener) {
        this.zzx.zza(new zzg(executor, onCanceledListener));
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final Task<TResult> addOnCanceledListener(@NonNull Activity activity, @NonNull OnCanceledListener onCanceledListener) {
        zzg zzg2 = new zzg(TaskExecutors.MAIN_THREAD, onCanceledListener);
        this.zzx.zza(zzg2);
        zza.zza(activity).zzb(zzg2);
        this.zze();
        return this;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> continueWithTask(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzx.zza(new zze<TResult, TContinuationResult>(executor, continuation, zzu2));
        this.zze();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(Executor executor, SuccessContinuation<TResult, TContinuationResult> successContinuation) {
        zzu<TResult> zzu2 = new zzu<TResult>();
        this.zzx.zza(new zzo<TResult, TContinuationResult>(executor, successContinuation, zzu2));
        this.zze();
        return zzu2;
    }

    @Override
    @NonNull
    public final <TContinuationResult> Task<TContinuationResult> onSuccessTask(@NonNull SuccessContinuation<TResult, TContinuationResult> successContinuation) {
        return ((Task)this).onSuccessTask(TaskExecutors.MAIN_THREAD, successContinuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(TResult TResult) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzc();
            this.zzy = true;
            this.zzaa = TResult;
        }
        this.zzx.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetResult(TResult TResult) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzy) {
                return false;
            }
            this.zzy = true;
            this.zzaa = TResult;
        }
        this.zzx.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(@NonNull Exception exception) {
        Preconditions.checkNotNull((Object)exception, (Object)"Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            this.zzc();
            this.zzy = true;
            this.zzab = exception;
        }
        this.zzx.zza(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean trySetException(@NonNull Exception exception) {
        Preconditions.checkNotNull((Object)exception, (Object)"Exception must not be null");
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzy) {
                return false;
            }
            this.zzy = true;
            this.zzab = exception;
        }
        this.zzx.zza(this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zza() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzy) {
                return false;
            }
            this.zzy = true;
            this.zzz = true;
        }
        this.zzx.zza(this);
        return true;
    }

    @GuardedBy(value="mLock")
    private final void zzb() {
        Preconditions.checkState((boolean)this.zzy, (Object)"Task is not yet complete");
    }

    @GuardedBy(value="mLock")
    private final void zzc() {
        Preconditions.checkState((!this.zzy ? 1 : 0) != 0, (Object)"Task is already complete");
    }

    @GuardedBy(value="mLock")
    private final void zzd() {
        if (this.zzz) {
            throw new CancellationException("Task is already canceled.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zze() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzy) {
                return;
            }
        }
        this.zzx.zza(this);
    }

    private static class zza
    extends LifecycleCallback {
        private final List<WeakReference<zzq<?>>> zzac = new ArrayList();

        public static zza zza(Activity activity) {
            LifecycleFragment lifecycleFragment = zza.getFragment((Activity)activity);
            zza zza2 = (zza)lifecycleFragment.getCallbackOrNull("TaskOnStopCallback", zza.class);
            if (zza2 == null) {
                zza2 = new zza(lifecycleFragment);
            }
            return zza2;
        }

        private zza(LifecycleFragment lifecycleFragment) {
            super(lifecycleFragment);
            this.mLifecycleFragment.addCallback("TaskOnStopCallback", (LifecycleCallback)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> void zzb(zzq<T> zzq2) {
            List<WeakReference<zzq<?>>> list = this.zzac;
            synchronized (list) {
                this.zzac.add(new WeakReference<zzq<T>>(zzq2));
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @MainThread
        public void onStop() {
            List<WeakReference<zzq<?>>> list = this.zzac;
            synchronized (list) {
                Iterator<WeakReference<zzq<?>>> iterator = this.zzac.iterator();
                while (iterator.hasNext()) {
                    zzq zzq2 = (zzq)iterator.next().get();
                    if (zzq2 == null) continue;
                    zzq2.cancel();
                }
                this.zzac.clear();
                return;
            }
        }
    }
}

