/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.net.Uri;
import android.util.Base64;
import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;

@UnstableApi
public final class DataSchemeDataSource
extends BaseDataSource {
    public static final String SCHEME_DATA = "data";
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private byte[] data;
    private int readPosition;
    private int bytesRemaining;

    public DataSchemeDataSource() {
        super(false);
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.transferInitializing(dataSpec);
        this.dataSpec = dataSpec;
        Uri uri = dataSpec.uri.normalizeScheme();
        String scheme = uri.getScheme();
        Assertions.checkArgument((boolean)SCHEME_DATA.equals(scheme), (Object)("Unsupported scheme: " + scheme));
        String[] uriParts = Util.split((String)uri.getSchemeSpecificPart(), (String)",");
        if (uriParts.length != 2) {
            throw ParserException.createForMalformedDataOfUnknownType((String)("Unexpected URI format: " + uri), null);
        }
        String dataString = uriParts[1];
        if (uriParts[0].contains(";base64")) {
            try {
                this.data = Base64.decode((String)dataString, (int)0);
            }
            catch (IllegalArgumentException e) {
                throw ParserException.createForMalformedDataOfUnknownType((String)("Error while parsing Base64 encoded string: " + dataString), (Throwable)e);
            }
        } else {
            this.data = Util.getUtf8Bytes((String)URLDecoder.decode(dataString, StandardCharsets.US_ASCII.name()));
        }
        if (dataSpec.position > (long)this.data.length) {
            this.data = null;
            throw new DataSourceException(2008);
        }
        this.readPosition = (int)dataSpec.position;
        this.bytesRemaining = this.data.length - this.readPosition;
        if (dataSpec.length != -1L) {
            this.bytesRemaining = (int)Math.min((long)this.bytesRemaining, dataSpec.length);
        }
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : (long)this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0) {
            return -1;
        }
        length = Math.min(length, this.bytesRemaining);
        System.arraycopy(Util.castNonNull((Object)this.data), this.readPosition, buffer, offset, length);
        this.readPosition += length;
        this.bytesRemaining -= length;
        this.bytesTransferred(length);
        return length;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.dataSpec != null ? this.dataSpec.uri : null;
    }

    @Override
    public void close() {
        if (this.data != null) {
            this.data = null;
            this.transferEnded();
        }
        this.dataSpec = null;
    }
}

