/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.AssetDataSource;
import androidx.media3.datasource.ContentDataSource;
import androidx.media3.datasource.DataSchemeDataSource;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultHttpDataSource;
import androidx.media3.datasource.FileDataSource;
import androidx.media3.datasource.RawResourceDataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.datasource.UdpDataSource;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class DefaultDataSource
implements DataSource {
    private static final String TAG = "DefaultDataSource";
    private static final String SCHEME_ASSET = "asset";
    private static final String SCHEME_CONTENT = "content";
    private static final String SCHEME_RTMP = "rtmp";
    private static final String SCHEME_UDP = "udp";
    private static final String SCHEME_DATA = "data";
    private static final String SCHEME_RAW = "rawresource";
    private static final String SCHEME_ANDROID_RESOURCE = "android.resource";
    private final Context context;
    private final List<TransferListener> transferListeners;
    private final DataSource baseDataSource;
    @Nullable
    private DataSource fileDataSource;
    @Nullable
    private DataSource assetDataSource;
    @Nullable
    private DataSource contentDataSource;
    @Nullable
    private DataSource rtmpDataSource;
    @Nullable
    private DataSource udpDataSource;
    @Nullable
    private DataSource dataSchemeDataSource;
    @Nullable
    private DataSource rawResourceDataSource;
    @Nullable
    private DataSource dataSource;

    @UnstableApi
    public DefaultDataSource(Context context, boolean allowCrossProtocolRedirects) {
        this(context, null, 8000, 8000, allowCrossProtocolRedirects);
    }

    @UnstableApi
    public DefaultDataSource(Context context, @Nullable String userAgent, boolean allowCrossProtocolRedirects) {
        this(context, userAgent, 8000, 8000, allowCrossProtocolRedirects);
    }

    @UnstableApi
    public DefaultDataSource(Context context, @Nullable String userAgent, int connectTimeoutMillis, int readTimeoutMillis, boolean allowCrossProtocolRedirects) {
        this(context, new DefaultHttpDataSource.Factory().setUserAgent(userAgent).setConnectTimeoutMs(connectTimeoutMillis).setReadTimeoutMs(readTimeoutMillis).setAllowCrossProtocolRedirects(allowCrossProtocolRedirects).createDataSource());
    }

    @UnstableApi
    public DefaultDataSource(Context context, DataSource baseDataSource) {
        this.context = context.getApplicationContext();
        this.baseDataSource = (DataSource)Assertions.checkNotNull((Object)baseDataSource);
        this.transferListeners = new ArrayList<TransferListener>();
    }

    @Override
    @UnstableApi
    public void addTransferListener(TransferListener transferListener) {
        Assertions.checkNotNull((Object)transferListener);
        this.baseDataSource.addTransferListener(transferListener);
        this.transferListeners.add(transferListener);
        this.maybeAddListenerToDataSource(this.fileDataSource, transferListener);
        this.maybeAddListenerToDataSource(this.assetDataSource, transferListener);
        this.maybeAddListenerToDataSource(this.contentDataSource, transferListener);
        this.maybeAddListenerToDataSource(this.rtmpDataSource, transferListener);
        this.maybeAddListenerToDataSource(this.udpDataSource, transferListener);
        this.maybeAddListenerToDataSource(this.dataSchemeDataSource, transferListener);
        this.maybeAddListenerToDataSource(this.rawResourceDataSource, transferListener);
    }

    @Override
    @UnstableApi
    public long open(DataSpec dataSpec) throws IOException {
        String uriPath;
        Assertions.checkState((this.dataSource == null ? 1 : 0) != 0);
        String scheme = dataSpec.uri.getScheme();
        this.dataSource = Util.isLocalFileUri((Uri)dataSpec.uri) ? ((uriPath = dataSpec.uri.getPath()) != null && uriPath.startsWith("/android_asset/") ? this.getAssetDataSource() : this.getFileDataSource()) : (SCHEME_ASSET.equals(scheme) ? this.getAssetDataSource() : (SCHEME_CONTENT.equals(scheme) ? this.getContentDataSource() : (SCHEME_RTMP.equals(scheme) ? this.getRtmpDataSource() : (SCHEME_UDP.equals(scheme) ? this.getUdpDataSource() : (SCHEME_DATA.equals(scheme) ? this.getDataSchemeDataSource() : (SCHEME_RAW.equals(scheme) || SCHEME_ANDROID_RESOURCE.equals(scheme) ? this.getRawResourceDataSource() : this.baseDataSource))))));
        return this.dataSource.open(dataSpec);
    }

    @UnstableApi
    public int read(byte[] buffer, int offset, int length) throws IOException {
        return ((DataSource)Assertions.checkNotNull((Object)this.dataSource)).read(buffer, offset, length);
    }

    @Override
    @UnstableApi
    @Nullable
    public Uri getUri() {
        return this.dataSource == null ? null : this.dataSource.getUri();
    }

    @Override
    @UnstableApi
    public Map<String, List<String>> getResponseHeaders() {
        return this.dataSource == null ? Collections.emptyMap() : this.dataSource.getResponseHeaders();
    }

    @Override
    @UnstableApi
    public void close() throws IOException {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    private DataSource getUdpDataSource() {
        if (this.udpDataSource == null) {
            this.udpDataSource = new UdpDataSource();
            this.addListenersToDataSource(this.udpDataSource);
        }
        return this.udpDataSource;
    }

    private DataSource getFileDataSource() {
        if (this.fileDataSource == null) {
            this.fileDataSource = new FileDataSource();
            this.addListenersToDataSource(this.fileDataSource);
        }
        return this.fileDataSource;
    }

    private DataSource getAssetDataSource() {
        if (this.assetDataSource == null) {
            this.assetDataSource = new AssetDataSource(this.context);
            this.addListenersToDataSource(this.assetDataSource);
        }
        return this.assetDataSource;
    }

    private DataSource getContentDataSource() {
        if (this.contentDataSource == null) {
            this.contentDataSource = new ContentDataSource(this.context);
            this.addListenersToDataSource(this.contentDataSource);
        }
        return this.contentDataSource;
    }

    private DataSource getRtmpDataSource() {
        if (this.rtmpDataSource == null) {
            try {
                Class<?> clazz = Class.forName("androidx.media3.datasource.rtmp.RtmpDataSource");
                this.rtmpDataSource = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.addListenersToDataSource(this.rtmpDataSource);
            }
            catch (ClassNotFoundException e) {
                Log.w((String)TAG, (String)"Attempting to play RTMP stream without depending on the RTMP extension");
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating RTMP extension", e);
            }
            if (this.rtmpDataSource == null) {
                this.rtmpDataSource = this.baseDataSource;
            }
        }
        return this.rtmpDataSource;
    }

    private DataSource getDataSchemeDataSource() {
        if (this.dataSchemeDataSource == null) {
            this.dataSchemeDataSource = new DataSchemeDataSource();
            this.addListenersToDataSource(this.dataSchemeDataSource);
        }
        return this.dataSchemeDataSource;
    }

    private DataSource getRawResourceDataSource() {
        if (this.rawResourceDataSource == null) {
            this.rawResourceDataSource = new RawResourceDataSource(this.context);
            this.addListenersToDataSource(this.rawResourceDataSource);
        }
        return this.rawResourceDataSource;
    }

    private void addListenersToDataSource(DataSource dataSource) {
        for (int i = 0; i < this.transferListeners.size(); ++i) {
            dataSource.addTransferListener(this.transferListeners.get(i));
        }
    }

    private void maybeAddListenerToDataSource(@Nullable DataSource dataSource, TransferListener listener) {
        if (dataSource != null) {
            dataSource.addTransferListener(listener);
        }
    }

    public static final class Factory
    implements DataSource.Factory {
        private final Context context;
        private final DataSource.Factory baseDataSourceFactory;
        @Nullable
        private TransferListener transferListener;

        public Factory(Context context) {
            this(context, new DefaultHttpDataSource.Factory());
        }

        public Factory(Context context, DataSource.Factory baseDataSourceFactory) {
            this.context = context.getApplicationContext();
            this.baseDataSourceFactory = (DataSource.Factory)Assertions.checkNotNull((Object)baseDataSourceFactory);
        }

        @CanIgnoreReturnValue
        @UnstableApi
        public Factory setTransferListener(@Nullable TransferListener transferListener) {
            this.transferListener = transferListener;
            return this;
        }

        @Override
        @UnstableApi
        public DefaultDataSource createDataSource() {
            DefaultDataSource dataSource = new DefaultDataSource(this.context, this.baseDataSourceFactory.createDataSource());
            if (this.transferListener != null) {
                dataSource.addTransferListener(this.transferListener);
            }
            return dataSource;
        }
    }
}

