/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.media.MediaDataSource;
import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import java.io.IOException;

@RequiresApi(value=23)
@UnstableApi
public class MediaDataSourceAdapter
extends BaseDataSource {
    private final MediaDataSource mediaDataSource;
    @Nullable
    private Uri uri;
    private long position;
    private long bytesRemaining;
    private boolean opened;

    public MediaDataSourceAdapter(MediaDataSource mediaDataSource, boolean isNetwork) {
        super(isNetwork);
        this.mediaDataSource = mediaDataSource;
    }

    @Override
    public long open(DataSpec dataSpec) throws IOException {
        this.uri = dataSpec.uri;
        this.position = dataSpec.position;
        this.transferInitializing(dataSpec);
        if (this.mediaDataSource.getSize() != -1L && this.position > this.mediaDataSource.getSize()) {
            throw new DataSourceException(2008);
        }
        this.bytesRemaining = this.mediaDataSource.getSize() == -1L ? -1L : this.mediaDataSource.getSize() - this.position;
        if (dataSpec.length != -1L) {
            this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
    }

    public int read(byte[] buffer, int offset, int length) throws DataSourceException {
        int bytesRead;
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int bytesToRead = this.bytesRemaining == -1L ? length : (int)Math.min(this.bytesRemaining, (long)length);
        try {
            bytesRead = this.mediaDataSource.readAt(this.position, buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new DataSourceException(e, 2000);
        }
        if (bytesRead == -1) {
            return -1;
        }
        this.position += (long)bytesRead;
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() throws IOException {
        this.uri = null;
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
        }
    }
}

