/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.BaseDataSource;
import androidx.media3.datasource.DataSourceException;
import androidx.media3.datasource.DataSpec;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.List;

@UnstableApi
public final class RawResourceDataSource
extends BaseDataSource {
    @Deprecated
    public static final String RAW_RESOURCE_SCHEME = "rawresource";
    private final Context applicationContext;
    @Nullable
    private DataSpec dataSpec;
    @Nullable
    private AssetFileDescriptor assetFileDescriptor;
    @Nullable
    private InputStream inputStream;
    private long bytesRemaining;
    private boolean opened;

    @Deprecated
    public static Uri buildRawResourceUri(int rawResourceId) {
        return Uri.parse((String)("rawresource:///" + rawResourceId));
    }

    public RawResourceDataSource(Context context) {
        super(false);
        this.applicationContext = context.getApplicationContext();
    }

    @Override
    public long open(DataSpec dataSpec) throws RawResourceDataSourceException {
        this.dataSpec = dataSpec;
        this.transferInitializing(dataSpec);
        this.assetFileDescriptor = RawResourceDataSource.openAssetFileDescriptor(this.applicationContext, dataSpec);
        long assetFileDescriptorLength = this.assetFileDescriptor.getLength();
        FileInputStream inputStream = new FileInputStream(this.assetFileDescriptor.getFileDescriptor());
        this.inputStream = inputStream;
        try {
            if (assetFileDescriptorLength != -1L && dataSpec.position > assetFileDescriptorLength) {
                throw new RawResourceDataSourceException(null, null, 2008);
            }
            long assetFileDescriptorOffset = this.assetFileDescriptor.getStartOffset();
            long skipped = inputStream.skip(assetFileDescriptorOffset + dataSpec.position) - assetFileDescriptorOffset;
            if (skipped != dataSpec.position) {
                throw new RawResourceDataSourceException(null, null, 2008);
            }
            if (assetFileDescriptorLength == -1L) {
                FileChannel channel = inputStream.getChannel();
                if (channel.size() == 0L) {
                    this.bytesRemaining = -1L;
                } else {
                    this.bytesRemaining = channel.size() - channel.position();
                    if (this.bytesRemaining < 0L) {
                        throw new RawResourceDataSourceException(null, null, 2008);
                    }
                }
            } else {
                this.bytesRemaining = assetFileDescriptorLength - skipped;
                if (this.bytesRemaining < 0L) {
                    throw new DataSourceException(2008);
                }
            }
        }
        catch (RawResourceDataSourceException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(null, e, 2000);
        }
        if (dataSpec.length != -1L) {
            this.bytesRemaining = this.bytesRemaining == -1L ? dataSpec.length : Math.min(this.bytesRemaining, dataSpec.length);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return dataSpec.length != -1L ? dataSpec.length : this.bytesRemaining;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AssetFileDescriptor openAssetFileDescriptor(Context applicationContext, DataSpec dataSpec) throws RawResourceDataSourceException {
        AssetFileDescriptor assetFileDescriptor;
        int resourceId;
        Resources resources;
        Uri normalizedUri = dataSpec.uri.normalizeScheme();
        if (TextUtils.equals((CharSequence)RAW_RESOURCE_SCHEME, (CharSequence)normalizedUri.getScheme())) {
            resources = applicationContext.getResources();
            List pathSegments = normalizedUri.getPathSegments();
            if (pathSegments.size() != 1) throw new RawResourceDataSourceException("rawresource:// URI must have exactly one path element, found " + pathSegments.size());
            resourceId = RawResourceDataSource.parseResourceId((String)pathSegments.get(0));
        } else {
            String packageName;
            if (!TextUtils.equals((CharSequence)"android.resource", (CharSequence)normalizedUri.getScheme())) throw new RawResourceDataSourceException("Unsupported URI scheme (" + normalizedUri.getScheme() + "). Only " + "android.resource" + " is supported.", null, 1004);
            String path = (String)Assertions.checkNotNull((Object)normalizedUri.getPath());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String string = packageName = TextUtils.isEmpty((CharSequence)normalizedUri.getHost()) ? applicationContext.getPackageName() : normalizedUri.getHost();
            if (packageName.equals(applicationContext.getPackageName())) {
                resources = applicationContext.getResources();
            } else {
                try {
                    resources = applicationContext.getPackageManager().getResourcesForApplication(packageName);
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new RawResourceDataSourceException("Package in android.resource:// URI not found. Check http://g.co/dev/packagevisibility.", e, 2005);
                }
            }
            if (path.matches("\\d+")) {
                resourceId = RawResourceDataSource.parseResourceId(path);
            } else {
                int resourceIdFromName = resources.getIdentifier(packageName + ":" + path, "raw", null);
                if (resourceIdFromName == 0) throw new RawResourceDataSourceException("Resource not found.", null, 2005);
                resourceId = resourceIdFromName;
            }
        }
        try {
            assetFileDescriptor = resources.openRawResourceFd(resourceId);
        }
        catch (Resources.NotFoundException e) {
            throw new RawResourceDataSourceException(null, e, 2005);
        }
        if (assetFileDescriptor != null) return assetFileDescriptor;
        throw new RawResourceDataSourceException("Resource is compressed: " + normalizedUri, null, 2000);
    }

    private static int parseResourceId(String resourceId) throws RawResourceDataSourceException {
        try {
            return Integer.parseInt(resourceId);
        }
        catch (NumberFormatException e) {
            throw new RawResourceDataSourceException("Resource identifier must be an integer.", null, 1004);
        }
    }

    public int read(byte[] buffer, int offset, int length) throws RawResourceDataSourceException {
        int bytesRead;
        if (length == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            int bytesToRead = this.bytesRemaining == -1L ? length : (int)Math.min(this.bytesRemaining, (long)length);
            bytesRead = ((InputStream)Util.castNonNull((Object)this.inputStream)).read(buffer, offset, bytesToRead);
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(null, e, 2000);
        }
        if (bytesRead == -1) {
            if (this.bytesRemaining != -1L) {
                throw new RawResourceDataSourceException("End of stream reached having not read sufficient data.", new EOFException(), 2000);
            }
            return -1;
        }
        if (this.bytesRemaining != -1L) {
            this.bytesRemaining -= (long)bytesRead;
        }
        this.bytesTransferred(bytesRead);
        return bytesRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.dataSpec != null ? this.dataSpec.uri : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws RawResourceDataSourceException {
        this.dataSpec = null;
        try {
            if (this.inputStream == null) return;
            this.inputStream.close();
            return;
        }
        catch (IOException e) {
            throw new RawResourceDataSourceException(null, e, 2000);
        }
        finally {
            this.inputStream = null;
            try {
                if (this.assetFileDescriptor != null) {
                    this.assetFileDescriptor.close();
                }
            }
            catch (IOException e) {
                throw new RawResourceDataSourceException(null, e, 2000);
            }
            finally {
                this.assetFileDescriptor = null;
                if (this.opened) {
                    this.opened = false;
                    this.transferEnded();
                }
            }
        }
    }

    public static class RawResourceDataSourceException
    extends DataSourceException {
        @Deprecated
        public RawResourceDataSourceException(String message) {
            super(message, null, 2000);
        }

        @Deprecated
        public RawResourceDataSourceException(Throwable cause) {
            super(cause, 2000);
        }

        public RawResourceDataSourceException(@Nullable String message, @Nullable Throwable cause, int errorCode) {
            super(message, cause, errorCode);
        }
    }
}

