/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.Player;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.RepeatModeUtil;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.ui.DefaultTimeBar;
import androidx.media3.ui.R;
import androidx.media3.ui.TimeBar;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;

@UnstableApi
public class LegacyPlayerControlView
extends FrameLayout {
    public static final int DEFAULT_SHOW_TIMEOUT_MS = 5000;
    public static final int DEFAULT_REPEAT_TOGGLE_MODES = 0;
    public static final int DEFAULT_TIME_BAR_MIN_UPDATE_INTERVAL_MS = 200;
    public static final int MAX_WINDOWS_FOR_MULTI_WINDOW_TIME_BAR = 100;
    private static final int MAX_UPDATE_INTERVAL_MS = 1000;
    private final ComponentListener componentListener;
    private final CopyOnWriteArrayList<VisibilityListener> visibilityListeners;
    @Nullable
    private final View previousButton;
    @Nullable
    private final View nextButton;
    @Nullable
    private final View playButton;
    @Nullable
    private final View pauseButton;
    @Nullable
    private final View fastForwardButton;
    @Nullable
    private final View rewindButton;
    @Nullable
    private final ImageView repeatToggleButton;
    @Nullable
    private final ImageView shuffleButton;
    @Nullable
    private final View vrButton;
    @Nullable
    private final TextView durationView;
    @Nullable
    private final TextView positionView;
    @Nullable
    private final TimeBar timeBar;
    private final StringBuilder formatBuilder;
    private final Formatter formatter;
    private final Timeline.Period period;
    private final Timeline.Window window;
    private final Runnable updateProgressAction;
    private final Runnable hideAction;
    private final Drawable repeatOffButtonDrawable;
    private final Drawable repeatOneButtonDrawable;
    private final Drawable repeatAllButtonDrawable;
    private final String repeatOffButtonContentDescription;
    private final String repeatOneButtonContentDescription;
    private final String repeatAllButtonContentDescription;
    private final Drawable shuffleOnButtonDrawable;
    private final Drawable shuffleOffButtonDrawable;
    private final float buttonAlphaEnabled;
    private final float buttonAlphaDisabled;
    private final String shuffleOnContentDescription;
    private final String shuffleOffContentDescription;
    @Nullable
    private Player player;
    @Nullable
    private ProgressUpdateListener progressUpdateListener;
    private boolean isAttachedToWindow;
    private boolean showMultiWindowTimeBar;
    private boolean showPlayButtonIfSuppressed;
    private boolean multiWindowTimeBar;
    private boolean scrubbing;
    private int showTimeoutMs;
    private int timeBarMinUpdateIntervalMs;
    private int repeatToggleModes;
    private boolean showRewindButton;
    private boolean showFastForwardButton;
    private boolean showPreviousButton;
    private boolean showNextButton;
    private boolean showShuffleButton;
    private long hideAtMs;
    private long[] adGroupTimesMs;
    private boolean[] playedAdGroups;
    private long[] extraAdGroupTimesMs;
    private boolean[] extraPlayedAdGroups;
    private long currentWindowOffset;
    private long currentPosition;
    private long currentBufferedPosition;

    public LegacyPlayerControlView(Context context) {
        this(context, null);
    }

    public LegacyPlayerControlView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LegacyPlayerControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LegacyPlayerControlView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, @Nullable AttributeSet playbackAttrs) {
        super(context, attrs, defStyleAttr);
        int controllerLayoutId = R.layout.exo_legacy_player_control_view;
        this.showPlayButtonIfSuppressed = true;
        this.showTimeoutMs = 5000;
        this.repeatToggleModes = 0;
        this.timeBarMinUpdateIntervalMs = 200;
        this.hideAtMs = -9223372036854775807L;
        this.showRewindButton = true;
        this.showFastForwardButton = true;
        this.showPreviousButton = true;
        this.showNextButton = true;
        this.showShuffleButton = false;
        if (playbackAttrs != null) {
            TypedArray a = context.getTheme().obtainStyledAttributes(playbackAttrs, R.styleable.LegacyPlayerControlView, defStyleAttr, 0);
            try {
                this.showTimeoutMs = a.getInt(R.styleable.LegacyPlayerControlView_show_timeout, this.showTimeoutMs);
                controllerLayoutId = a.getResourceId(R.styleable.LegacyPlayerControlView_controller_layout_id, controllerLayoutId);
                this.repeatToggleModes = LegacyPlayerControlView.getRepeatToggleModes(a, this.repeatToggleModes);
                this.showRewindButton = a.getBoolean(R.styleable.LegacyPlayerControlView_show_rewind_button, this.showRewindButton);
                this.showFastForwardButton = a.getBoolean(R.styleable.LegacyPlayerControlView_show_fastforward_button, this.showFastForwardButton);
                this.showPreviousButton = a.getBoolean(R.styleable.LegacyPlayerControlView_show_previous_button, this.showPreviousButton);
                this.showNextButton = a.getBoolean(R.styleable.LegacyPlayerControlView_show_next_button, this.showNextButton);
                this.showShuffleButton = a.getBoolean(R.styleable.LegacyPlayerControlView_show_shuffle_button, this.showShuffleButton);
                this.setTimeBarMinUpdateInterval(a.getInt(R.styleable.LegacyPlayerControlView_time_bar_min_update_interval, this.timeBarMinUpdateIntervalMs));
            }
            finally {
                a.recycle();
            }
        }
        this.visibilityListeners = new CopyOnWriteArrayList();
        this.period = new Timeline.Period();
        this.window = new Timeline.Window();
        this.formatBuilder = new StringBuilder();
        this.formatter = new Formatter(this.formatBuilder, Locale.getDefault());
        this.adGroupTimesMs = new long[0];
        this.playedAdGroups = new boolean[0];
        this.extraAdGroupTimesMs = new long[0];
        this.extraPlayedAdGroups = new boolean[0];
        this.componentListener = new ComponentListener();
        this.updateProgressAction = this::updateProgress;
        this.hideAction = this::hide;
        LayoutInflater.from((Context)context).inflate(controllerLayoutId, (ViewGroup)this);
        this.setDescendantFocusability(262144);
        TimeBar customTimeBar = (TimeBar)this.findViewById(R.id.exo_progress);
        View timeBarPlaceholder = this.findViewById(R.id.exo_progress_placeholder);
        if (customTimeBar != null) {
            this.timeBar = customTimeBar;
        } else if (timeBarPlaceholder != null) {
            DefaultTimeBar defaultTimeBar = new DefaultTimeBar(context, null, 0, playbackAttrs);
            defaultTimeBar.setId(R.id.exo_progress);
            defaultTimeBar.setLayoutParams(timeBarPlaceholder.getLayoutParams());
            ViewGroup parent = (ViewGroup)timeBarPlaceholder.getParent();
            int timeBarIndex = parent.indexOfChild(timeBarPlaceholder);
            parent.removeView(timeBarPlaceholder);
            parent.addView((View)defaultTimeBar, timeBarIndex);
            this.timeBar = defaultTimeBar;
        } else {
            this.timeBar = null;
        }
        this.durationView = (TextView)this.findViewById(R.id.exo_duration);
        this.positionView = (TextView)this.findViewById(R.id.exo_position);
        if (this.timeBar != null) {
            this.timeBar.addListener(this.componentListener);
        }
        this.playButton = this.findViewById(R.id.exo_play);
        if (this.playButton != null) {
            this.playButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.pauseButton = this.findViewById(R.id.exo_pause);
        if (this.pauseButton != null) {
            this.pauseButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.previousButton = this.findViewById(R.id.exo_prev);
        if (this.previousButton != null) {
            this.previousButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.nextButton = this.findViewById(R.id.exo_next);
        if (this.nextButton != null) {
            this.nextButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.rewindButton = this.findViewById(R.id.exo_rew);
        if (this.rewindButton != null) {
            this.rewindButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.fastForwardButton = this.findViewById(R.id.exo_ffwd);
        if (this.fastForwardButton != null) {
            this.fastForwardButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.repeatToggleButton = (ImageView)this.findViewById(R.id.exo_repeat_toggle);
        if (this.repeatToggleButton != null) {
            this.repeatToggleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.shuffleButton = (ImageView)this.findViewById(R.id.exo_shuffle);
        if (this.shuffleButton != null) {
            this.shuffleButton.setOnClickListener((View.OnClickListener)this.componentListener);
        }
        this.vrButton = this.findViewById(R.id.exo_vr);
        this.setShowVrButton(false);
        this.updateButton(false, false, this.vrButton);
        Resources resources = context.getResources();
        this.buttonAlphaEnabled = (float)resources.getInteger(R.integer.exo_media_button_opacity_percentage_enabled) / 100.0f;
        this.buttonAlphaDisabled = (float)resources.getInteger(R.integer.exo_media_button_opacity_percentage_disabled) / 100.0f;
        this.repeatOffButtonDrawable = Util.getDrawable((Context)context, (Resources)resources, (int)R.drawable.exo_legacy_controls_repeat_off);
        this.repeatOneButtonDrawable = Util.getDrawable((Context)context, (Resources)resources, (int)R.drawable.exo_legacy_controls_repeat_one);
        this.repeatAllButtonDrawable = Util.getDrawable((Context)context, (Resources)resources, (int)R.drawable.exo_legacy_controls_repeat_all);
        this.shuffleOnButtonDrawable = Util.getDrawable((Context)context, (Resources)resources, (int)R.drawable.exo_legacy_controls_shuffle_on);
        this.shuffleOffButtonDrawable = Util.getDrawable((Context)context, (Resources)resources, (int)R.drawable.exo_legacy_controls_shuffle_off);
        this.repeatOffButtonContentDescription = resources.getString(R.string.exo_controls_repeat_off_description);
        this.repeatOneButtonContentDescription = resources.getString(R.string.exo_controls_repeat_one_description);
        this.repeatAllButtonContentDescription = resources.getString(R.string.exo_controls_repeat_all_description);
        this.shuffleOnContentDescription = resources.getString(R.string.exo_controls_shuffle_on_description);
        this.shuffleOffContentDescription = resources.getString(R.string.exo_controls_shuffle_off_description);
        this.currentPosition = -9223372036854775807L;
        this.currentBufferedPosition = -9223372036854775807L;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(@Nullable Player player) {
        Assertions.checkState((Looper.myLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        Assertions.checkArgument((player == null || player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        if (this.player == player) {
            return;
        }
        if (this.player != null) {
            this.player.removeListener((Player.Listener)this.componentListener);
        }
        this.player = player;
        if (player != null) {
            player.addListener((Player.Listener)this.componentListener);
        }
        this.updateAll();
    }

    @Deprecated
    public void setShowMultiWindowTimeBar(boolean showMultiWindowTimeBar) {
        this.showMultiWindowTimeBar = showMultiWindowTimeBar;
        this.updateTimeline();
    }

    public void setShowPlayButtonIfPlaybackIsSuppressed(boolean showPlayButtonIfSuppressed) {
        this.showPlayButtonIfSuppressed = showPlayButtonIfSuppressed;
        this.updatePlayPauseButton();
    }

    public void setExtraAdGroupMarkers(@Nullable long[] extraAdGroupTimesMs, @Nullable boolean[] extraPlayedAdGroups) {
        if (extraAdGroupTimesMs == null) {
            this.extraAdGroupTimesMs = new long[0];
            this.extraPlayedAdGroups = new boolean[0];
        } else {
            Assertions.checkArgument((extraAdGroupTimesMs.length == (extraPlayedAdGroups = (boolean[])Assertions.checkNotNull((Object)extraPlayedAdGroups)).length ? 1 : 0) != 0);
            this.extraAdGroupTimesMs = extraAdGroupTimesMs;
            this.extraPlayedAdGroups = extraPlayedAdGroups;
        }
        this.updateTimeline();
    }

    public void addVisibilityListener(VisibilityListener listener) {
        Assertions.checkNotNull((Object)listener);
        this.visibilityListeners.add(listener);
    }

    public void removeVisibilityListener(VisibilityListener listener) {
        this.visibilityListeners.remove(listener);
    }

    public void setProgressUpdateListener(@Nullable ProgressUpdateListener listener) {
        this.progressUpdateListener = listener;
    }

    public void setShowRewindButton(boolean showRewindButton) {
        this.showRewindButton = showRewindButton;
        this.updateNavigation();
    }

    public void setShowFastForwardButton(boolean showFastForwardButton) {
        this.showFastForwardButton = showFastForwardButton;
        this.updateNavigation();
    }

    public void setShowPreviousButton(boolean showPreviousButton) {
        this.showPreviousButton = showPreviousButton;
        this.updateNavigation();
    }

    public void setShowNextButton(boolean showNextButton) {
        this.showNextButton = showNextButton;
        this.updateNavigation();
    }

    public int getShowTimeoutMs() {
        return this.showTimeoutMs;
    }

    public void setShowTimeoutMs(int showTimeoutMs) {
        this.showTimeoutMs = showTimeoutMs;
        if (this.isVisible()) {
            this.hideAfterTimeout();
        }
    }

    public int getRepeatToggleModes() {
        return this.repeatToggleModes;
    }

    public void setRepeatToggleModes(int repeatToggleModes) {
        this.repeatToggleModes = repeatToggleModes;
        if (this.player != null) {
            int currentMode = this.player.getRepeatMode();
            if (repeatToggleModes == 0 && currentMode != 0) {
                this.player.setRepeatMode(0);
            } else if (repeatToggleModes == 1 && currentMode == 2) {
                this.player.setRepeatMode(1);
            } else if (repeatToggleModes == 2 && currentMode == 1) {
                this.player.setRepeatMode(2);
            }
        }
        this.updateRepeatModeButton();
    }

    public boolean getShowShuffleButton() {
        return this.showShuffleButton;
    }

    public void setShowShuffleButton(boolean showShuffleButton) {
        this.showShuffleButton = showShuffleButton;
        this.updateShuffleButton();
    }

    public boolean getShowVrButton() {
        return this.vrButton != null && this.vrButton.getVisibility() == 0;
    }

    public void setShowVrButton(boolean showVrButton) {
        if (this.vrButton != null) {
            this.vrButton.setVisibility(showVrButton ? 0 : 8);
        }
    }

    public void setVrButtonListener(@Nullable View.OnClickListener onClickListener) {
        if (this.vrButton != null) {
            this.vrButton.setOnClickListener(onClickListener);
            this.updateButton(this.getShowVrButton(), onClickListener != null, this.vrButton);
        }
    }

    public void setTimeBarMinUpdateInterval(int minUpdateIntervalMs) {
        this.timeBarMinUpdateIntervalMs = Util.constrainValue((int)minUpdateIntervalMs, (int)16, (int)1000);
    }

    public void show() {
        if (!this.isVisible()) {
            this.setVisibility(0);
            for (VisibilityListener visibilityListener : this.visibilityListeners) {
                visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.updateAll();
            this.requestPlayPauseFocus();
            this.requestPlayPauseAccessibilityFocus();
        }
        this.hideAfterTimeout();
    }

    public void hide() {
        if (this.isVisible()) {
            this.setVisibility(8);
            for (VisibilityListener visibilityListener : this.visibilityListeners) {
                visibilityListener.onVisibilityChange(this.getVisibility());
            }
            this.removeCallbacks(this.updateProgressAction);
            this.removeCallbacks(this.hideAction);
            this.hideAtMs = -9223372036854775807L;
        }
    }

    public boolean isVisible() {
        return this.getVisibility() == 0;
    }

    private void hideAfterTimeout() {
        this.removeCallbacks(this.hideAction);
        if (this.showTimeoutMs > 0) {
            this.hideAtMs = SystemClock.uptimeMillis() + (long)this.showTimeoutMs;
            if (this.isAttachedToWindow) {
                this.postDelayed(this.hideAction, this.showTimeoutMs);
            }
        } else {
            this.hideAtMs = -9223372036854775807L;
        }
    }

    private void updateAll() {
        this.updatePlayPauseButton();
        this.updateNavigation();
        this.updateRepeatModeButton();
        this.updateShuffleButton();
        this.updateTimeline();
    }

    private void updatePlayPauseButton() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        boolean requestPlayPauseFocus = false;
        boolean requestPlayPauseAccessibilityFocus = false;
        boolean shouldShowPlayButton = Util.shouldShowPlayButton((Player)this.player, (boolean)this.showPlayButtonIfSuppressed);
        if (this.playButton != null) {
            requestPlayPauseFocus = !shouldShowPlayButton && this.playButton.isFocused();
            requestPlayPauseAccessibilityFocus = !shouldShowPlayButton && this.playButton.isAccessibilityFocused();
            this.playButton.setVisibility(shouldShowPlayButton ? 0 : 8);
        }
        if (this.pauseButton != null) {
            requestPlayPauseFocus |= shouldShowPlayButton && this.pauseButton.isFocused();
            requestPlayPauseAccessibilityFocus |= shouldShowPlayButton && this.pauseButton.isAccessibilityFocused();
            this.pauseButton.setVisibility(shouldShowPlayButton ? 8 : 0);
        }
        if (requestPlayPauseFocus) {
            this.requestPlayPauseFocus();
        }
        if (requestPlayPauseAccessibilityFocus) {
            this.requestPlayPauseAccessibilityFocus();
        }
    }

    private void updateNavigation() {
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Player player = this.player;
        boolean enableSeeking = false;
        boolean enablePrevious = false;
        boolean enableRewind = false;
        boolean enableFastForward = false;
        boolean enableNext = false;
        if (player != null) {
            enableSeeking = player.isCommandAvailable(5);
            enablePrevious = player.isCommandAvailable(7);
            enableRewind = player.isCommandAvailable(11);
            enableFastForward = player.isCommandAvailable(12);
            enableNext = player.isCommandAvailable(9);
        }
        this.updateButton(this.showPreviousButton, enablePrevious, this.previousButton);
        this.updateButton(this.showRewindButton, enableRewind, this.rewindButton);
        this.updateButton(this.showFastForwardButton, enableFastForward, this.fastForwardButton);
        this.updateButton(this.showNextButton, enableNext, this.nextButton);
        if (this.timeBar != null) {
            this.timeBar.setEnabled(enableSeeking);
        }
    }

    private void updateRepeatModeButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.repeatToggleButton == null) {
            return;
        }
        if (this.repeatToggleModes == 0) {
            this.updateButton(false, false, (View)this.repeatToggleButton);
            return;
        }
        Player player = this.player;
        if (player == null) {
            this.updateButton(true, false, (View)this.repeatToggleButton);
            this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
            this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
            return;
        }
        this.updateButton(true, true, (View)this.repeatToggleButton);
        switch (player.getRepeatMode()) {
            case 0: {
                this.repeatToggleButton.setImageDrawable(this.repeatOffButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOffButtonContentDescription);
                break;
            }
            case 1: {
                this.repeatToggleButton.setImageDrawable(this.repeatOneButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatOneButtonContentDescription);
                break;
            }
            case 2: {
                this.repeatToggleButton.setImageDrawable(this.repeatAllButtonDrawable);
                this.repeatToggleButton.setContentDescription((CharSequence)this.repeatAllButtonContentDescription);
                break;
            }
        }
        this.repeatToggleButton.setVisibility(0);
    }

    private void updateShuffleButton() {
        if (!this.isVisible() || !this.isAttachedToWindow || this.shuffleButton == null) {
            return;
        }
        Player player = this.player;
        if (!this.showShuffleButton) {
            this.updateButton(false, false, (View)this.shuffleButton);
        } else if (player == null) {
            this.updateButton(true, false, (View)this.shuffleButton);
            this.shuffleButton.setImageDrawable(this.shuffleOffButtonDrawable);
            this.shuffleButton.setContentDescription((CharSequence)this.shuffleOffContentDescription);
        } else {
            this.updateButton(true, true, (View)this.shuffleButton);
            this.shuffleButton.setImageDrawable(player.getShuffleModeEnabled() ? this.shuffleOnButtonDrawable : this.shuffleOffButtonDrawable);
            this.shuffleButton.setContentDescription((CharSequence)(player.getShuffleModeEnabled() ? this.shuffleOnContentDescription : this.shuffleOffContentDescription));
        }
    }

    private void updateTimeline() {
        Player player = this.player;
        if (player == null) {
            return;
        }
        this.multiWindowTimeBar = this.showMultiWindowTimeBar && LegacyPlayerControlView.canShowMultiWindowTimeBar(player.getCurrentTimeline(), this.window);
        this.currentWindowOffset = 0L;
        long durationUs = 0L;
        int adGroupCount = 0;
        Timeline timeline = player.getCurrentTimeline();
        if (!timeline.isEmpty()) {
            int currentWindowIndex = player.getCurrentMediaItemIndex();
            int firstWindowIndex = this.multiWindowTimeBar ? 0 : currentWindowIndex;
            int lastWindowIndex = this.multiWindowTimeBar ? timeline.getWindowCount() - 1 : currentWindowIndex;
            for (int i = firstWindowIndex; i <= lastWindowIndex; ++i) {
                if (i == currentWindowIndex) {
                    this.currentWindowOffset = Util.usToMs((long)durationUs);
                }
                timeline.getWindow(i, this.window);
                if (this.window.durationUs == -9223372036854775807L) {
                    Assertions.checkState((!this.multiWindowTimeBar ? 1 : 0) != 0);
                    break;
                }
                for (int j = this.window.firstPeriodIndex; j <= this.window.lastPeriodIndex; ++j) {
                    timeline.getPeriod(j, this.period);
                    int removedGroups = this.period.getRemovedAdGroupCount();
                    int totalGroups = this.period.getAdGroupCount();
                    for (int adGroupIndex = removedGroups; adGroupIndex < totalGroups; ++adGroupIndex) {
                        long adGroupTimeInWindowUs;
                        long adGroupTimeInPeriodUs = this.period.getAdGroupTimeUs(adGroupIndex);
                        if (adGroupTimeInPeriodUs == Long.MIN_VALUE) {
                            if (this.period.durationUs == -9223372036854775807L) continue;
                            adGroupTimeInPeriodUs = this.period.durationUs;
                        }
                        if ((adGroupTimeInWindowUs = adGroupTimeInPeriodUs + this.period.getPositionInWindowUs()) < 0L) continue;
                        if (adGroupCount == this.adGroupTimesMs.length) {
                            int newLength = this.adGroupTimesMs.length == 0 ? 1 : this.adGroupTimesMs.length * 2;
                            this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, newLength);
                            this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, newLength);
                        }
                        this.adGroupTimesMs[adGroupCount] = Util.usToMs((long)(durationUs + adGroupTimeInWindowUs));
                        this.playedAdGroups[adGroupCount] = this.period.hasPlayedAdGroup(adGroupIndex);
                        ++adGroupCount;
                    }
                }
                durationUs += this.window.durationUs;
            }
        }
        long durationMs = Util.usToMs((long)durationUs);
        if (this.durationView != null) {
            this.durationView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)durationMs));
        }
        if (this.timeBar != null) {
            this.timeBar.setDuration(durationMs);
            int extraAdGroupCount = this.extraAdGroupTimesMs.length;
            int totalAdGroupCount = adGroupCount + extraAdGroupCount;
            if (totalAdGroupCount > this.adGroupTimesMs.length) {
                this.adGroupTimesMs = Arrays.copyOf(this.adGroupTimesMs, totalAdGroupCount);
                this.playedAdGroups = Arrays.copyOf(this.playedAdGroups, totalAdGroupCount);
            }
            System.arraycopy(this.extraAdGroupTimesMs, 0, this.adGroupTimesMs, adGroupCount, extraAdGroupCount);
            System.arraycopy(this.extraPlayedAdGroups, 0, this.playedAdGroups, adGroupCount, extraAdGroupCount);
            this.timeBar.setAdGroupTimesMs(this.adGroupTimesMs, this.playedAdGroups, totalAdGroupCount);
        }
        this.updateProgress();
    }

    private void updateProgress() {
        int playbackState;
        if (!this.isVisible() || !this.isAttachedToWindow) {
            return;
        }
        Player player = this.player;
        long position = 0L;
        long bufferedPosition = 0L;
        if (player != null) {
            position = this.currentWindowOffset + player.getContentPosition();
            bufferedPosition = this.currentWindowOffset + player.getContentBufferedPosition();
        }
        boolean positionChanged = position != this.currentPosition;
        boolean bufferedPositionChanged = bufferedPosition != this.currentBufferedPosition;
        this.currentPosition = position;
        this.currentBufferedPosition = bufferedPosition;
        if (this.positionView != null && !this.scrubbing && positionChanged) {
            this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)this.formatBuilder, (Formatter)this.formatter, (long)position));
        }
        if (this.timeBar != null) {
            this.timeBar.setPosition(position);
            this.timeBar.setBufferedPosition(bufferedPosition);
        }
        if (this.progressUpdateListener != null && (positionChanged || bufferedPositionChanged)) {
            this.progressUpdateListener.onProgressUpdate(position, bufferedPosition);
        }
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = player == null ? 1 : player.getPlaybackState();
        if (player != null && player.isPlaying()) {
            long mediaTimeDelayMs = this.timeBar != null ? this.timeBar.getPreferredUpdateDelay() : 1000L;
            long mediaTimeUntilNextFullSecondMs = 1000L - position % 1000L;
            mediaTimeDelayMs = Math.min(mediaTimeDelayMs, mediaTimeUntilNextFullSecondMs);
            float playbackSpeed = player.getPlaybackParameters().speed;
            long delayMs = playbackSpeed > 0.0f ? (long)((float)mediaTimeDelayMs / playbackSpeed) : 1000L;
            delayMs = Util.constrainValue((long)delayMs, (long)this.timeBarMinUpdateIntervalMs, (long)1000L);
            this.postDelayed(this.updateProgressAction, delayMs);
        } else if (playbackState != 4 && playbackState != 1) {
            this.postDelayed(this.updateProgressAction, 1000L);
        }
    }

    private void requestPlayPauseFocus() {
        boolean shouldShowPlayButton = Util.shouldShowPlayButton((Player)this.player, (boolean)this.showPlayButtonIfSuppressed);
        if (shouldShowPlayButton && this.playButton != null) {
            this.playButton.requestFocus();
        } else if (!shouldShowPlayButton && this.pauseButton != null) {
            this.pauseButton.requestFocus();
        }
    }

    private void requestPlayPauseAccessibilityFocus() {
        boolean shouldShowPlayButton = Util.shouldShowPlayButton((Player)this.player, (boolean)this.showPlayButtonIfSuppressed);
        if (shouldShowPlayButton && this.playButton != null) {
            this.playButton.sendAccessibilityEvent(8);
        } else if (!shouldShowPlayButton && this.pauseButton != null) {
            this.pauseButton.sendAccessibilityEvent(8);
        }
    }

    private void updateButton(boolean visible, boolean enabled, @Nullable View view) {
        if (view == null) {
            return;
        }
        view.setEnabled(enabled);
        view.setAlpha(enabled ? this.buttonAlphaEnabled : this.buttonAlphaDisabled);
        view.setVisibility(visible ? 0 : 8);
    }

    private void seekToTimeBarPosition(Player player, long positionMs) {
        int windowIndex;
        Timeline timeline = player.getCurrentTimeline();
        if (this.multiWindowTimeBar && !timeline.isEmpty()) {
            long windowDurationMs;
            int windowCount = timeline.getWindowCount();
            windowIndex = 0;
            while (positionMs >= (windowDurationMs = timeline.getWindow(windowIndex, this.window).getDurationMs())) {
                if (windowIndex == windowCount - 1) {
                    positionMs = windowDurationMs;
                    break;
                }
                positionMs -= windowDurationMs;
                ++windowIndex;
            }
        } else {
            windowIndex = player.getCurrentMediaItemIndex();
        }
        this.seekTo(player, windowIndex, positionMs);
        this.updateProgress();
    }

    private void seekTo(Player player, int windowIndex, long positionMs) {
        player.seekTo(windowIndex, positionMs);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
        if (this.hideAtMs != -9223372036854775807L) {
            long delayMs = this.hideAtMs - SystemClock.uptimeMillis();
            if (delayMs <= 0L) {
                this.hide();
            } else {
                this.postDelayed(this.hideAction, delayMs);
            }
        } else if (this.isVisible()) {
            this.hideAfterTimeout();
        }
        this.updateAll();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
        this.removeCallbacks(this.hideAction);
    }

    public final boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.removeCallbacks(this.hideAction);
        } else if (ev.getAction() == 1) {
            this.hideAfterTimeout();
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.dispatchMediaKeyEvent(event) || super.dispatchKeyEvent(event);
    }

    public boolean dispatchMediaKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        Player player = this.player;
        if (player == null || !LegacyPlayerControlView.isHandledMediaKey(keyCode)) {
            return false;
        }
        if (event.getAction() == 0) {
            if (keyCode == 90) {
                if (player.getPlaybackState() != 4) {
                    player.seekForward();
                }
            } else if (keyCode == 89) {
                player.seekBack();
            } else if (event.getRepeatCount() == 0) {
                switch (keyCode) {
                    case 79: 
                    case 85: {
                        Util.handlePlayPauseButtonAction((Player)player, (boolean)this.showPlayButtonIfSuppressed);
                        break;
                    }
                    case 126: {
                        Util.handlePlayButtonAction((Player)player);
                        break;
                    }
                    case 127: {
                        Util.handlePauseButtonAction((Player)player);
                        break;
                    }
                    case 87: {
                        player.seekToNext();
                        break;
                    }
                    case 88: {
                        player.seekToPrevious();
                        break;
                    }
                }
            }
        }
        return true;
    }

    @SuppressLint(value={"InlinedApi"})
    private static boolean isHandledMediaKey(int keyCode) {
        return keyCode == 90 || keyCode == 89 || keyCode == 85 || keyCode == 79 || keyCode == 126 || keyCode == 127 || keyCode == 87 || keyCode == 88;
    }

    private static boolean canShowMultiWindowTimeBar(Timeline timeline, Timeline.Window window) {
        if (timeline.getWindowCount() > 100) {
            return false;
        }
        int windowCount = timeline.getWindowCount();
        for (int i = 0; i < windowCount; ++i) {
            if (timeline.getWindow((int)i, (Timeline.Window)window).durationUs != -9223372036854775807L) continue;
            return false;
        }
        return true;
    }

    private static int getRepeatToggleModes(TypedArray a, int defaultValue) {
        return a.getInt(R.styleable.LegacyPlayerControlView_repeat_toggle_modes, defaultValue);
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.ui");
    }

    private final class ComponentListener
    implements Player.Listener,
    TimeBar.OnScrubListener,
    View.OnClickListener {
        private ComponentListener() {
        }

        public void onEvents(Player player, Player.Events events) {
            if (events.containsAny(new int[]{4, 5})) {
                LegacyPlayerControlView.this.updatePlayPauseButton();
            }
            if (events.containsAny(new int[]{4, 5, 7})) {
                LegacyPlayerControlView.this.updateProgress();
            }
            if (events.contains(8)) {
                LegacyPlayerControlView.this.updateRepeatModeButton();
            }
            if (events.contains(9)) {
                LegacyPlayerControlView.this.updateShuffleButton();
            }
            if (events.containsAny(new int[]{8, 9, 11, 0, 13})) {
                LegacyPlayerControlView.this.updateNavigation();
            }
            if (events.containsAny(new int[]{11, 0})) {
                LegacyPlayerControlView.this.updateTimeline();
            }
        }

        @Override
        public void onScrubStart(TimeBar timeBar, long position) {
            LegacyPlayerControlView.this.scrubbing = true;
            if (LegacyPlayerControlView.this.positionView != null) {
                LegacyPlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)LegacyPlayerControlView.this.formatBuilder, (Formatter)LegacyPlayerControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubMove(TimeBar timeBar, long position) {
            if (LegacyPlayerControlView.this.positionView != null) {
                LegacyPlayerControlView.this.positionView.setText((CharSequence)Util.getStringForTime((StringBuilder)LegacyPlayerControlView.this.formatBuilder, (Formatter)LegacyPlayerControlView.this.formatter, (long)position));
            }
        }

        @Override
        public void onScrubStop(TimeBar timeBar, long position, boolean canceled) {
            LegacyPlayerControlView.this.scrubbing = false;
            if (!canceled && LegacyPlayerControlView.this.player != null) {
                LegacyPlayerControlView.this.seekToTimeBarPosition(LegacyPlayerControlView.this.player, position);
            }
        }

        public void onClick(View view) {
            Player player = LegacyPlayerControlView.this.player;
            if (player == null) {
                return;
            }
            if (LegacyPlayerControlView.this.nextButton == view) {
                player.seekToNext();
            } else if (LegacyPlayerControlView.this.previousButton == view) {
                player.seekToPrevious();
            } else if (LegacyPlayerControlView.this.fastForwardButton == view) {
                if (player.getPlaybackState() != 4) {
                    player.seekForward();
                }
            } else if (LegacyPlayerControlView.this.rewindButton == view) {
                player.seekBack();
            } else if (LegacyPlayerControlView.this.playButton == view) {
                Util.handlePlayButtonAction((Player)player);
            } else if (LegacyPlayerControlView.this.pauseButton == view) {
                Util.handlePauseButtonAction((Player)player);
            } else if (LegacyPlayerControlView.this.repeatToggleButton == view) {
                player.setRepeatMode(RepeatModeUtil.getNextRepeatMode((int)player.getRepeatMode(), (int)LegacyPlayerControlView.this.repeatToggleModes));
            } else if (LegacyPlayerControlView.this.shuffleButton == view) {
                player.setShuffleModeEnabled(!player.getShuffleModeEnabled());
            }
        }
    }

    public static interface ProgressUpdateListener {
        public void onProgressUpdate(long var1, long var3);
    }

    public static interface VisibilityListener {
        public void onVisibilityChange(int var1);
    }
}

