/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.accessibility;

import android.os.StrictMode;
import android.util.Log;
import android.view.View;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.action.ViewActions;
import androidx.test.espresso.util.HumanReadables;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultDescriptor;
import com.google.android.apps.common.testing.accessibility.framework.integrations.espresso.AccessibilityValidator;

public final class AccessibilityChecks {
    private static final AccessibilityValidator CHECK_EXECUTOR = new AccessibilityValidator().setResultDescriptor(new AccessibilityCheckResultDescriptor(){

        public String describeView(View view) {
            return HumanReadables.describe((View)view);
        }
    });
    private static final ViewAssertion ACCESSIBILITY_CHECK_ASSERTION = new ViewAssertion(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void check(View view, NoMatchingViewException noViewFoundException) {
            if (noViewFoundException != null) {
                Log.e((String)AccessibilityChecks.TAG, (String)String.format("'accessibility checks could not be performed because view '%s' was notfound.\n", noViewFoundException.getViewMatcherDescription()));
                throw noViewFoundException;
            }
            if (view == null) {
                throw new NullPointerException();
            }
            StrictMode.ThreadPolicy originalPolicy = StrictMode.allowThreadDiskWrites();
            try {
                CHECK_EXECUTOR.check(view);
            }
            finally {
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)originalPolicy);
            }
        }
    };
    private static boolean checksEnabled = false;
    private static final String TAG = "AccessibilityChecks";

    private AccessibilityChecks() {
    }

    public static AccessibilityValidator enable() {
        if (checksEnabled) {
            Log.w((String)TAG, (String)"Accessibility checks already enabled.");
        } else {
            checksEnabled = true;
            ViewActions.addGlobalAssertion((String)"Accessibility Checks", (ViewAssertion)ACCESSIBILITY_CHECK_ASSERTION);
        }
        return CHECK_EXECUTOR;
    }

    public static void disable() {
        if (!checksEnabled) {
            throw new IllegalStateException("Accessibility checks not enabled!");
        }
        checksEnabled = false;
        ViewActions.removeGlobalAssertion((ViewAssertion)ACCESSIBILITY_CHECK_ASSERTION);
    }

    public static ViewAssertion accessibilityAssertion() {
        return ACCESSIBILITY_CHECK_ASSERTION;
    }
}

