/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso;

import android.os.Looper;
import android.util.Log;
import androidx.test.espresso.IdlingResource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class IdlingRegistry {
    private static final String TAG = IdlingRegistry.class.getSimpleName();
    private static final IdlingRegistry instance = new IdlingRegistry();
    private final Set<IdlingResource> resources = Collections.synchronizedSet(new HashSet());
    private final Set<Looper> loopers = Collections.synchronizedSet(new HashSet());

    IdlingRegistry() {
    }

    public static IdlingRegistry getInstance() {
        return instance;
    }

    public boolean register(IdlingResource ... idlingResources) {
        if (null == idlingResources) {
            throw new NullPointerException("idlingResources cannot be null!");
        }
        Log.d((String)TAG, (String)("Registering idling resources: " + Arrays.toString(idlingResources)));
        return this.resources.addAll(Arrays.asList(idlingResources));
    }

    public boolean unregister(IdlingResource ... idlingResources) {
        if (null == idlingResources) {
            throw new NullPointerException("idlingResources cannot be null!");
        }
        Log.d((String)TAG, (String)("Unregistering idling resources: " + Arrays.toString(idlingResources)));
        return this.resources.removeAll(Arrays.asList(idlingResources));
    }

    public void registerLooperAsIdlingResource(Looper looper) {
        if (null == looper) {
            throw new NullPointerException("looper cannot be null!");
        }
        if (Looper.getMainLooper() == looper) {
            throw new IllegalArgumentException("Not intended for use with main looper!");
        }
        this.loopers.add(looper);
    }

    public boolean unregisterLooperAsIdlingResource(Looper looper) {
        if (null == looper) {
            throw new NullPointerException("looper cannot be null!");
        }
        return this.loopers.remove(looper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IdlingResource> getResources() {
        Set<IdlingResource> set = this.resources;
        synchronized (set) {
            return new HashSet<IdlingResource>(this.resources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Looper> getLoopers() {
        Set<Looper> set = this.loopers;
        synchronized (set) {
            return new HashSet<Looper>(this.loopers);
        }
    }
}

