/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import androidx.test.espresso.intent.ActivityResultFunction;
import androidx.test.espresso.intent.Checks;
import androidx.test.espresso.intent.ResettingStubber;
import org.hamcrest.Matcher;

public final class OngoingStubbing {
    private final Matcher<Intent> matcher;
    private final ResettingStubber resettingStubber;
    private final Instrumentation instrumentation;

    OngoingStubbing(Matcher<Intent> matcher, ResettingStubber resettingStubber, Instrumentation instrumentation) {
        this.matcher = Checks.checkNotNull(matcher);
        this.resettingStubber = Checks.checkNotNull(resettingStubber);
        this.instrumentation = Checks.checkNotNull(instrumentation);
    }

    public void respondWith(Instrumentation.ActivityResult result) {
        this.respondWithFunction(intent -> Checks.checkNotNull(result));
    }

    public void respondWithFunction(ActivityResultFunction result) {
        Checks.checkNotNull(result);
        this.instrumentation.waitForIdleSync();
        this.instrumentation.runOnMainSync(() -> this.resettingStubber.setActivityResultFunctionForIntent(this.matcher, result));
        this.instrumentation.waitForIdleSync();
    }
}

